@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsResourceProviderArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.ProviderPermissionsScope
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource provider details include the required permissions for the user to create connections.
 * The user should have the required permissions(Read\Write, ..) in the specified scope ProviderPermissionsScope against the specified resource provider.
 * @property permissionsDisplayText Gets or sets the permissions description text.
 * @property provider Gets or sets the provider name.
 * @property providerDisplayName Gets or sets the permissions provider display name.
 * @property requiredPermissions Required permissions for the connector resource provider that define in ResourceProviders.
 * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
 * @property scope The scope on which the user should have permissions, in order to be able to create connections.
 */
public data class ConnectorDefinitionsResourceProviderArgs(
    public val permissionsDisplayText: Output<String>,
    public val provider: Output<String>,
    public val providerDisplayName: Output<String>,
    public val requiredPermissions: Output<ResourceProviderRequiredPermissionsArgs>,
    public val scope: Output<Either<String, ProviderPermissionsScope>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsResourceProviderArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsResourceProviderArgs =
        com.pulumi.azurenative.securityinsights.inputs.ConnectorDefinitionsResourceProviderArgs.builder()
            .permissionsDisplayText(permissionsDisplayText.applyValue({ args0 -> args0 }))
            .provider(provider.applyValue({ args0 -> args0 }))
            .providerDisplayName(providerDisplayName.applyValue({ args0 -> args0 }))
            .requiredPermissions(
                requiredPermissions.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scope(
                scope.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorDefinitionsResourceProviderArgs].
 */
@PulumiTagMarker
public class ConnectorDefinitionsResourceProviderArgsBuilder internal constructor() {
    private var permissionsDisplayText: Output<String>? = null

    private var provider: Output<String>? = null

    private var providerDisplayName: Output<String>? = null

    private var requiredPermissions: Output<ResourceProviderRequiredPermissionsArgs>? = null

    private var scope: Output<Either<String, ProviderPermissionsScope>>? = null

    /**
     * @param value Gets or sets the permissions description text.
     */
    @JvmName("jbfgqipbesdifgkx")
    public suspend fun permissionsDisplayText(`value`: Output<String>) {
        this.permissionsDisplayText = value
    }

    /**
     * @param value Gets or sets the provider name.
     */
    @JvmName("ptvvxwjxfjgwblyo")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value Gets or sets the permissions provider display name.
     */
    @JvmName("syidbkrmgxestdpb")
    public suspend fun providerDisplayName(`value`: Output<String>) {
        this.providerDisplayName = value
    }

    /**
     * @param value Required permissions for the connector resource provider that define in ResourceProviders.
     * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
     */
    @JvmName("wsqjywjxfcidpajw")
    public suspend fun requiredPermissions(`value`: Output<ResourceProviderRequiredPermissionsArgs>) {
        this.requiredPermissions = value
    }

    /**
     * @param value The scope on which the user should have permissions, in order to be able to create connections.
     */
    @JvmName("gcvfwasukpacuhgu")
    public suspend fun scope(`value`: Output<Either<String, ProviderPermissionsScope>>) {
        this.scope = value
    }

    /**
     * @param value Gets or sets the permissions description text.
     */
    @JvmName("cyjfixpkqpvmllim")
    public suspend fun permissionsDisplayText(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionsDisplayText = mapped
    }

    /**
     * @param value Gets or sets the provider name.
     */
    @JvmName("rwwdwvpjrsvmhcag")
    public suspend fun provider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Gets or sets the permissions provider display name.
     */
    @JvmName("eyeokvigsqeshica")
    public suspend fun providerDisplayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerDisplayName = mapped
    }

    /**
     * @param value Required permissions for the connector resource provider that define in ResourceProviders.
     * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
     */
    @JvmName("lmxkkukmdhuerokm")
    public suspend fun requiredPermissions(`value`: ResourceProviderRequiredPermissionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredPermissions = mapped
    }

    /**
     * @param argument Required permissions for the connector resource provider that define in ResourceProviders.
     * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
     */
    @JvmName("trcaeboukldxytfj")
    public suspend
    fun requiredPermissions(argument: suspend ResourceProviderRequiredPermissionsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceProviderRequiredPermissionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.requiredPermissions = mapped
    }

    /**
     * @param value The scope on which the user should have permissions, in order to be able to create connections.
     */
    @JvmName("eqwsklwrnwaporto")
    public suspend fun scope(`value`: Either<String, ProviderPermissionsScope>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope on which the user should have permissions, in order to be able to create connections.
     */
    @JvmName("vntiiopjxomivxap")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProviderPermissionsScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The scope on which the user should have permissions, in order to be able to create connections.
     */
    @JvmName("lunkocjtbhnwkfee")
    public fun scope(`value`: ProviderPermissionsScope) {
        val toBeMapped = Either.ofRight<String, ProviderPermissionsScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): ConnectorDefinitionsResourceProviderArgs =
        ConnectorDefinitionsResourceProviderArgs(
            permissionsDisplayText = permissionsDisplayText ?: throw
                PulumiNullFieldException("permissionsDisplayText"),
            provider = provider ?: throw PulumiNullFieldException("provider"),
            providerDisplayName = providerDisplayName ?: throw PulumiNullFieldException("providerDisplayName"),
            requiredPermissions = requiredPermissions ?: throw PulumiNullFieldException("requiredPermissions"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
