@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetActivityCustomEntityQueryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityQueryId entity query ID
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetActivityCustomEntityQueryPlainArgs(
    public val entityQueryId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetActivityCustomEntityQueryPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetActivityCustomEntityQueryPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetActivityCustomEntityQueryPlainArgs.builder()
            .entityQueryId(entityQueryId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActivityCustomEntityQueryPlainArgs].
 */
@PulumiTagMarker
public class GetActivityCustomEntityQueryPlainArgsBuilder internal constructor() {
    private var entityQueryId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value entity query ID
     */
    @JvmName("jsmjsvtkmcmjeree")
    public suspend fun entityQueryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entityQueryId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cpqctcbdijsdhhdv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hrqbjmrhyrbwapcf")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetActivityCustomEntityQueryPlainArgs =
        GetActivityCustomEntityQueryPlainArgs(
            entityQueryId = entityQueryId ?: throw PulumiNullFieldException("entityQueryId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
