@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetEntitiesGetTimelinePlainArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.EntityTimelineKind
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property endTime The end timeline date, so the results returned are before this date.
 * @property entityId entity ID
 * @property kinds Array of timeline Item kinds.
 * @property numberOfBucket The number of bucket for timeline queries aggregation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property startTime The start timeline date, so the results returned are after this date.
 * @property workspaceName The name of the workspace.
 */
public data class GetEntitiesGetTimelinePlainArgs(
    public val endTime: String,
    public val entityId: String,
    public val kinds: List<Either<String, EntityTimelineKind>>? = null,
    public val numberOfBucket: Int? = null,
    public val resourceGroupName: String,
    public val startTime: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetEntitiesGetTimelinePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetEntitiesGetTimelinePlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetEntitiesGetTimelinePlainArgs.builder()
            .endTime(endTime.let({ args0 -> args0 }))
            .entityId(entityId.let({ args0 -> args0 }))
            .kinds(
                kinds?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .numberOfBucket(numberOfBucket?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startTime(startTime.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEntitiesGetTimelinePlainArgs].
 */
@PulumiTagMarker
public class GetEntitiesGetTimelinePlainArgsBuilder internal constructor() {
    private var endTime: String? = null

    private var entityId: String? = null

    private var kinds: List<Either<String, EntityTimelineKind>>? = null

    private var numberOfBucket: Int? = null

    private var resourceGroupName: String? = null

    private var startTime: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The end timeline date, so the results returned are before this date.
     */
    @JvmName("mvamipertybfkdic")
    public suspend fun endTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value entity ID
     */
    @JvmName("whcehxyyvibjxcqv")
    public suspend fun entityId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entityId = mapped
    }

    /**
     * @param value Array of timeline Item kinds.
     */
    @JvmName("wwywbwjqjrvlcejd")
    public suspend fun kinds(`value`: List<Either<String, EntityTimelineKind>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kinds = mapped
    }

    /**
     * @param values Array of timeline Item kinds.
     */
    @JvmName("vjkysxjuwpyhdakp")
    public suspend fun kinds(vararg values: Either<String, EntityTimelineKind>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kinds = mapped
    }

    /**
     * @param value The number of bucket for timeline queries aggregation.
     */
    @JvmName("vksryuktpdixkcin")
    public suspend fun numberOfBucket(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.numberOfBucket = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjfpfvgopommooec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start timeline date, so the results returned are after this date.
     */
    @JvmName("xelocxkbcxowvdds")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startTime = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pdjiatraydbrephg")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetEntitiesGetTimelinePlainArgs = GetEntitiesGetTimelinePlainArgs(
        endTime = endTime ?: throw PulumiNullFieldException("endTime"),
        entityId = entityId ?: throw PulumiNullFieldException("entityId"),
        kinds = kinds,
        numberOfBucket = numberOfBucket,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
