@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.IncidentPropertiesActionArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentClassification
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentClassificationReason
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentSeverity
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property classification The reason the incident was closed
 * @property classificationComment Describes the reason the incident was closed.
 * @property classificationReason The classification reason the incident was closed with
 * @property labels List of labels to add to the incident.
 * @property owner Information on the user an incident is assigned to
 * @property severity The severity of the incident
 * @property status The status of the incident
 */
public data class IncidentPropertiesActionArgs(
    public val classification: Output<Either<String, IncidentClassification>>? = null,
    public val classificationComment: Output<String>? = null,
    public val classificationReason: Output<Either<String, IncidentClassificationReason>>? = null,
    public val labels: Output<List<IncidentLabelArgs>>? = null,
    public val owner: Output<IncidentOwnerInfoArgs>? = null,
    public val severity: Output<Either<String, IncidentSeverity>>? = null,
    public val status: Output<Either<String, IncidentStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.IncidentPropertiesActionArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.IncidentPropertiesActionArgs =
        com.pulumi.azurenative.securityinsights.inputs.IncidentPropertiesActionArgs.builder()
            .classification(
                classification?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .classificationComment(classificationComment?.applyValue({ args0 -> args0 }))
            .classificationReason(
                classificationReason?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owner(owner?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IncidentPropertiesActionArgs].
 */
@PulumiTagMarker
public class IncidentPropertiesActionArgsBuilder internal constructor() {
    private var classification: Output<Either<String, IncidentClassification>>? = null

    private var classificationComment: Output<String>? = null

    private var classificationReason: Output<Either<String, IncidentClassificationReason>>? = null

    private var labels: Output<List<IncidentLabelArgs>>? = null

    private var owner: Output<IncidentOwnerInfoArgs>? = null

    private var severity: Output<Either<String, IncidentSeverity>>? = null

    private var status: Output<Either<String, IncidentStatus>>? = null

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("kbmhqrkjxcxsjghe")
    public suspend fun classification(`value`: Output<Either<String, IncidentClassification>>) {
        this.classification = value
    }

    /**
     * @param value Describes the reason the incident was closed.
     */
    @JvmName("jjflsmqrttevxmja")
    public suspend fun classificationComment(`value`: Output<String>) {
        this.classificationComment = value
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("apwpssavwftaldxl")
    public suspend
    fun classificationReason(`value`: Output<Either<String, IncidentClassificationReason>>) {
        this.classificationReason = value
    }

    /**
     * @param value List of labels to add to the incident.
     */
    @JvmName("qwtsdafhxkrauloh")
    public suspend fun labels(`value`: Output<List<IncidentLabelArgs>>) {
        this.labels = value
    }

    @JvmName("exskqoqvwjjrwmlw")
    public suspend fun labels(vararg values: Output<IncidentLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels to add to the incident.
     */
    @JvmName("byuhrsuifxgmanxi")
    public suspend fun labels(values: List<Output<IncidentLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Information on the user an incident is assigned to
     */
    @JvmName("eqvnokdsalsntrto")
    public suspend fun owner(`value`: Output<IncidentOwnerInfoArgs>) {
        this.owner = value
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("xqcacdaeuayalwos")
    public suspend fun severity(`value`: Output<Either<String, IncidentSeverity>>) {
        this.severity = value
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("fypsrfwievuqoanw")
    public suspend fun status(`value`: Output<Either<String, IncidentStatus>>) {
        this.status = value
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("kuspuqfjykouhlyt")
    public suspend fun classification(`value`: Either<String, IncidentClassification>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("jydmfnkvmbwuvkla")
    public fun classification(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentClassification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value The reason the incident was closed
     */
    @JvmName("ijoqxtrumumxdklm")
    public fun classification(`value`: IncidentClassification) {
        val toBeMapped = Either.ofRight<String, IncidentClassification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value Describes the reason the incident was closed.
     */
    @JvmName("gwfllheicibfytcf")
    public suspend fun classificationComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationComment = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("ppknqjuthndbbscv")
    public suspend fun classificationReason(`value`: Either<String, IncidentClassificationReason>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("mmjaiuewgmxeismy")
    public fun classificationReason(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentClassificationReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value The classification reason the incident was closed with
     */
    @JvmName("qjuoirkrvvuobmax")
    public fun classificationReason(`value`: IncidentClassificationReason) {
        val toBeMapped = Either.ofRight<String, IncidentClassificationReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationReason = mapped
    }

    /**
     * @param value List of labels to add to the incident.
     */
    @JvmName("xpjkaosrjlkcgfrh")
    public suspend fun labels(`value`: List<IncidentLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument List of labels to add to the incident.
     */
    @JvmName("fgndgcbkyckosown")
    public suspend fun labels(argument: List<suspend IncidentLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IncidentLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument List of labels to add to the incident.
     */
    @JvmName("oaxaxmkmgtnuhraa")
    public suspend fun labels(vararg argument: suspend IncidentLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IncidentLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument List of labels to add to the incident.
     */
    @JvmName("kixlayklahghraoy")
    public suspend fun labels(argument: suspend IncidentLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IncidentLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values List of labels to add to the incident.
     */
    @JvmName("mctkiddqwjycchjq")
    public suspend fun labels(vararg values: IncidentLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Information on the user an incident is assigned to
     */
    @JvmName("fjlwaccfyievacvq")
    public suspend fun owner(`value`: IncidentOwnerInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param argument Information on the user an incident is assigned to
     */
    @JvmName("vvrteseokwsdoihb")
    public suspend fun owner(argument: suspend IncidentOwnerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IncidentOwnerInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.owner = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("nlyxxhkpgvivgcee")
    public suspend fun severity(`value`: Either<String, IncidentSeverity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("ppnmgpmjckhrxeju")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("slhqmxanrddbvddm")
    public fun severity(`value`: IncidentSeverity) {
        val toBeMapped = Either.ofRight<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("qyitqnqqqnsnnacy")
    public suspend fun status(`value`: Either<String, IncidentStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("wwfnxuaomjnqsbmc")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the incident
     */
    @JvmName("fcttrqjgjkvskndg")
    public fun status(`value`: IncidentStatus) {
        val toBeMapped = Either.ofRight<String, IncidentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): IncidentPropertiesActionArgs = IncidentPropertiesActionArgs(
        classification = classification,
        classificationComment = classificationComment,
        classificationReason = classificationReason,
        labels = labels,
        owner = owner,
        severity = severity,
        status = status,
    )
}
