@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.PlaybookActionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logicAppResourceId The resource id of the playbook resource.
 * @property tenantId The tenant id of the playbook resource.
 */
public data class PlaybookActionPropertiesArgs(
    public val logicAppResourceId: Output<String>,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.PlaybookActionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.PlaybookActionPropertiesArgs =
        com.pulumi.azurenative.securityinsights.inputs.PlaybookActionPropertiesArgs.builder()
            .logicAppResourceId(logicAppResourceId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlaybookActionPropertiesArgs].
 */
@PulumiTagMarker
public class PlaybookActionPropertiesArgsBuilder internal constructor() {
    private var logicAppResourceId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The resource id of the playbook resource.
     */
    @JvmName("dqrsscuqyejpnafm")
    public suspend fun logicAppResourceId(`value`: Output<String>) {
        this.logicAppResourceId = value
    }

    /**
     * @param value The tenant id of the playbook resource.
     */
    @JvmName("lljqubmuxrqndhnu")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The resource id of the playbook resource.
     */
    @JvmName("veaspcdrgavasreb")
    public suspend fun logicAppResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logicAppResourceId = mapped
    }

    /**
     * @param value The tenant id of the playbook resource.
     */
    @JvmName("bwclhjktjucxoovl")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): PlaybookActionPropertiesArgs = PlaybookActionPropertiesArgs(
        logicAppResourceId = logicAppResourceId ?: throw PulumiNullFieldException("logicAppResourceId"),
        tenantId = tenantId,
    )
}
