@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.RepositoryResourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resources created in user's repository for the source-control.
 * @property azureDevOpsResourceInfo Resources created in Azure DevOps for this source-control.
 * @property gitHubResourceInfo Resources created in GitHub for this source-control.
 * @property webhook The webhook object created for the source-control.
 */
public data class RepositoryResourceInfoArgs(
    public val azureDevOpsResourceInfo: Output<AzureDevOpsResourceInfoArgs>? = null,
    public val gitHubResourceInfo: Output<GitHubResourceInfoArgs>? = null,
    public val webhook: Output<WebhookArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.RepositoryResourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.RepositoryResourceInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.RepositoryResourceInfoArgs.builder()
            .azureDevOpsResourceInfo(
                azureDevOpsResourceInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .gitHubResourceInfo(
                gitHubResourceInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .webhook(webhook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RepositoryResourceInfoArgs].
 */
@PulumiTagMarker
public class RepositoryResourceInfoArgsBuilder internal constructor() {
    private var azureDevOpsResourceInfo: Output<AzureDevOpsResourceInfoArgs>? = null

    private var gitHubResourceInfo: Output<GitHubResourceInfoArgs>? = null

    private var webhook: Output<WebhookArgs>? = null

    /**
     * @param value Resources created in Azure DevOps for this source-control.
     */
    @JvmName("winriyhhvaumdqje")
    public suspend fun azureDevOpsResourceInfo(`value`: Output<AzureDevOpsResourceInfoArgs>) {
        this.azureDevOpsResourceInfo = value
    }

    /**
     * @param value Resources created in GitHub for this source-control.
     */
    @JvmName("wyafxdtqhuxtyqqn")
    public suspend fun gitHubResourceInfo(`value`: Output<GitHubResourceInfoArgs>) {
        this.gitHubResourceInfo = value
    }

    /**
     * @param value The webhook object created for the source-control.
     */
    @JvmName("bfijamrwwnrcfgta")
    public suspend fun webhook(`value`: Output<WebhookArgs>) {
        this.webhook = value
    }

    /**
     * @param value Resources created in Azure DevOps for this source-control.
     */
    @JvmName("varayvjumiitckqe")
    public suspend fun azureDevOpsResourceInfo(`value`: AzureDevOpsResourceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDevOpsResourceInfo = mapped
    }

    /**
     * @param argument Resources created in Azure DevOps for this source-control.
     */
    @JvmName("kbgfnrylyiomkvpr")
    public suspend
    fun azureDevOpsResourceInfo(argument: suspend AzureDevOpsResourceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDevOpsResourceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureDevOpsResourceInfo = mapped
    }

    /**
     * @param value Resources created in GitHub for this source-control.
     */
    @JvmName("ssatokbxcitjepss")
    public suspend fun gitHubResourceInfo(`value`: GitHubResourceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubResourceInfo = mapped
    }

    /**
     * @param argument Resources created in GitHub for this source-control.
     */
    @JvmName("qdvoweyvjkdwlyim")
    public suspend
    fun gitHubResourceInfo(argument: suspend GitHubResourceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubResourceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHubResourceInfo = mapped
    }

    /**
     * @param value The webhook object created for the source-control.
     */
    @JvmName("tkacvndtdthheuty")
    public suspend fun webhook(`value`: WebhookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    /**
     * @param argument The webhook object created for the source-control.
     */
    @JvmName("ecyevgokbpnxudmd")
    public suspend fun webhook(argument: suspend WebhookArgsBuilder.() -> Unit) {
        val toBeMapped = WebhookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.webhook = mapped
    }

    internal fun build(): RepositoryResourceInfoArgs = RepositoryResourceInfoArgs(
        azureDevOpsResourceInfo = azureDevOpsResourceInfo,
        gitHubResourceInfo = gitHubResourceInfo,
        webhook = webhook,
    )
}
