@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ResourceProviderRequiredPermissionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Required permissions for the connector resource provider that define in ResourceProviders.
 * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
 * @property action Gets or sets a value indicating whether the permission is custom actions (POST).
 * @property delete Gets or sets a value indicating whether the permission is delete action (DELETE).
 * @property read Gets or sets a value indicating whether the permission is read action (GET).
 * @property write Gets or sets a value indicating whether the permission is write action (PUT or PATCH).
 */
public data class ResourceProviderRequiredPermissionsArgs(
    public val action: Output<Boolean>? = null,
    public val delete: Output<Boolean>? = null,
    public val read: Output<Boolean>? = null,
    public val write: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ResourceProviderRequiredPermissionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ResourceProviderRequiredPermissionsArgs =
        com.pulumi.azurenative.securityinsights.inputs.ResourceProviderRequiredPermissionsArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .read(read?.applyValue({ args0 -> args0 }))
            .write(write?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceProviderRequiredPermissionsArgs].
 */
@PulumiTagMarker
public class ResourceProviderRequiredPermissionsArgsBuilder internal constructor() {
    private var action: Output<Boolean>? = null

    private var delete: Output<Boolean>? = null

    private var read: Output<Boolean>? = null

    private var write: Output<Boolean>? = null

    /**
     * @param value Gets or sets a value indicating whether the permission is custom actions (POST).
     */
    @JvmName("eyfudxilujiklsst")
    public suspend fun action(`value`: Output<Boolean>) {
        this.action = value
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is delete action (DELETE).
     */
    @JvmName("cgpqcfxtwnshdlxc")
    public suspend fun delete(`value`: Output<Boolean>) {
        this.delete = value
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is read action (GET).
     */
    @JvmName("udsbeqcshmydxgca")
    public suspend fun read(`value`: Output<Boolean>) {
        this.read = value
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is write action (PUT or PATCH).
     */
    @JvmName("sgubjrvushhypcni")
    public suspend fun write(`value`: Output<Boolean>) {
        this.write = value
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is custom actions (POST).
     */
    @JvmName("dxopnuextcgxvagw")
    public suspend fun action(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is delete action (DELETE).
     */
    @JvmName("uombgdtjohauqcby")
    public suspend fun delete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is read action (GET).
     */
    @JvmName("ttudfqgtlxbgdkjj")
    public suspend fun read(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.read = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether the permission is write action (PUT or PATCH).
     */
    @JvmName("gdsphgxodffpemfx")
    public suspend fun write(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.write = mapped
    }

    internal fun build(): ResourceProviderRequiredPermissionsArgs =
        ResourceProviderRequiredPermissionsArgs(
            action = action,
            delete = delete,
            read = read,
            write = write,
        )
}
