@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesIndicatorsArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.DataTypeState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data type for indicators connection.
 * @property state Describe whether this data type connection is enabled or not.
 */
public data class TIDataConnectorDataTypesIndicatorsArgs(
    public val state: Output<Either<String, DataTypeState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesIndicatorsArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesIndicatorsArgs =
        com.pulumi.azurenative.securityinsights.inputs.TIDataConnectorDataTypesIndicatorsArgs.builder()
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TIDataConnectorDataTypesIndicatorsArgs].
 */
@PulumiTagMarker
public class TIDataConnectorDataTypesIndicatorsArgsBuilder internal constructor() {
    private var state: Output<Either<String, DataTypeState>>? = null

    /**
     * @param value Describe whether this data type connection is enabled or not.
     */
    @JvmName("viahwxlnakhnwaee")
    public suspend fun state(`value`: Output<Either<String, DataTypeState>>) {
        this.state = value
    }

    /**
     * @param value Describe whether this data type connection is enabled or not.
     */
    @JvmName("orywawrhjiiyxjbp")
    public suspend fun state(`value`: Either<String, DataTypeState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describe whether this data type connection is enabled or not.
     */
    @JvmName("btbfyhabysocoooe")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataTypeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describe whether this data type connection is enabled or not.
     */
    @JvmName("lmhsykbshobsjdkr")
    public fun state(`value`: DataTypeState) {
        val toBeMapped = Either.ofRight<String, DataTypeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): TIDataConnectorDataTypesIndicatorsArgs =
        TIDataConnectorDataTypesIndicatorsArgs(
            state = state,
        )
}
