@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceGranularMarkingModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes threat granular marking model entity
 * @property language Language granular marking model
 * @property markingRef marking reference granular marking model
 * @property selectors granular marking model selectors
 */
public data class ThreatIntelligenceGranularMarkingModelArgs(
    public val language: Output<String>? = null,
    public val markingRef: Output<Int>? = null,
    public val selectors: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceGranularMarkingModelArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceGranularMarkingModelArgs =
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceGranularMarkingModelArgs.builder()
            .language(language?.applyValue({ args0 -> args0 }))
            .markingRef(markingRef?.applyValue({ args0 -> args0 }))
            .selectors(selectors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ThreatIntelligenceGranularMarkingModelArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceGranularMarkingModelArgsBuilder internal constructor() {
    private var language: Output<String>? = null

    private var markingRef: Output<Int>? = null

    private var selectors: Output<List<String>>? = null

    /**
     * @param value Language granular marking model
     */
    @JvmName("cfwjlnggiiovbgrd")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value marking reference granular marking model
     */
    @JvmName("ljmyeanptyxufwrh")
    public suspend fun markingRef(`value`: Output<Int>) {
        this.markingRef = value
    }

    /**
     * @param value granular marking model selectors
     */
    @JvmName("kexvxgsbalgatcwt")
    public suspend fun selectors(`value`: Output<List<String>>) {
        this.selectors = value
    }

    @JvmName("sagmacwxakxadoit")
    public suspend fun selectors(vararg values: Output<String>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values granular marking model selectors
     */
    @JvmName("edkaadspdflrronf")
    public suspend fun selectors(values: List<Output<String>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value Language granular marking model
     */
    @JvmName("aaiplkjmjijbtxxu")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value marking reference granular marking model
     */
    @JvmName("vbwybygvkfhrrrnv")
    public suspend fun markingRef(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markingRef = mapped
    }

    /**
     * @param value granular marking model selectors
     */
    @JvmName("ijlgrsrnrxndoklt")
    public suspend fun selectors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param values granular marking model selectors
     */
    @JvmName("akoupdglawnntone")
    public suspend fun selectors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    internal fun build(): ThreatIntelligenceGranularMarkingModelArgs =
        ThreatIntelligenceGranularMarkingModelArgs(
            language = language,
            markingRef = markingRef,
            selectors = selectors,
        )
}
