@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceKillChainPhaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes threat kill chain phase entity
 * @property killChainName Kill chainName name
 * @property phaseName Phase name
 */
public data class ThreatIntelligenceKillChainPhaseArgs(
    public val killChainName: Output<String>? = null,
    public val phaseName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceKillChainPhaseArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceKillChainPhaseArgs =
        com.pulumi.azurenative.securityinsights.inputs.ThreatIntelligenceKillChainPhaseArgs.builder()
            .killChainName(killChainName?.applyValue({ args0 -> args0 }))
            .phaseName(phaseName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThreatIntelligenceKillChainPhaseArgs].
 */
@PulumiTagMarker
public class ThreatIntelligenceKillChainPhaseArgsBuilder internal constructor() {
    private var killChainName: Output<String>? = null

    private var phaseName: Output<String>? = null

    /**
     * @param value Kill chainName name
     */
    @JvmName("yeicrqyfngptjmoy")
    public suspend fun killChainName(`value`: Output<String>) {
        this.killChainName = value
    }

    /**
     * @param value Phase name
     */
    @JvmName("kbjlojwgyiuygmcq")
    public suspend fun phaseName(`value`: Output<String>) {
        this.phaseName = value
    }

    /**
     * @param value Kill chainName name
     */
    @JvmName("nxnucvwpmbsjqqys")
    public suspend fun killChainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.killChainName = mapped
    }

    /**
     * @param value Phase name
     */
    @JvmName("pdatdxcdiaipwbda")
    public suspend fun phaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phaseName = mapped
    }

    internal fun build(): ThreatIntelligenceKillChainPhaseArgs = ThreatIntelligenceKillChainPhaseArgs(
        killChainName = killChainName,
        phaseName = phaseName,
    )
}
