@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents Activity timeline item.
 * @property bucketEndTimeUTC The grouping bucket end time.
 * @property bucketStartTimeUTC The grouping bucket start time.
 * @property content The activity timeline content.
 * @property firstActivityTimeUTC The time of the first activity in the grouping bucket.
 * @property kind The entity query kind
 * Expected value is 'Activity'.
 * @property lastActivityTimeUTC The time of the last activity in the grouping bucket.
 * @property queryId The activity query id.
 * @property title The activity timeline title.
 */
public data class ActivityTimelineItemResponse(
    public val bucketEndTimeUTC: String,
    public val bucketStartTimeUTC: String,
    public val content: String,
    public val firstActivityTimeUTC: String,
    public val kind: String,
    public val lastActivityTimeUTC: String,
    public val queryId: String,
    public val title: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ActivityTimelineItemResponse):
            ActivityTimelineItemResponse = ActivityTimelineItemResponse(
            bucketEndTimeUTC = javaType.bucketEndTimeUTC(),
            bucketStartTimeUTC = javaType.bucketStartTimeUTC(),
            content = javaType.content(),
            firstActivityTimeUTC = javaType.firstActivityTimeUTC(),
            kind = javaType.kind(),
            lastActivityTimeUTC = javaType.lastActivityTimeUTC(),
            queryId = javaType.queryId(),
            title = javaType.title(),
        )
    }
}
