@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes automation rule triggering logic.
 * @property conditions The conditions to evaluate to determine if the automation rule should be triggered on a given object.
 * @property expirationTimeUtc Determines when the automation rule should automatically expire and be disabled.
 * @property isEnabled Determines whether the automation rule is enabled or disabled.
 * @property triggersOn
 * @property triggersWhen
 */
public data class AutomationRuleTriggeringLogicResponse(
    public val conditions: List<Any>? = null,
    public val expirationTimeUtc: String? = null,
    public val isEnabled: Boolean,
    public val triggersOn: String,
    public val triggersWhen: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AutomationRuleTriggeringLogicResponse):
            AutomationRuleTriggeringLogicResponse = AutomationRuleTriggeringLogicResponse(
            conditions = javaType.conditions().map({ args0 -> args0 }),
            expirationTimeUtc = javaType.expirationTimeUtc().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            triggersOn = javaType.triggersOn(),
            triggersWhen = javaType.triggersWhen(),
        )
    }
}
