@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The exposure status of the connector to the customers.
 * @property isPreview Gets or sets a value indicating whether the connector is preview.
 * @property status The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal).
 */
public data class ConnectorDefinitionsAvailabilityResponse(
    public val isPreview: Boolean? = null,
    public val status: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ConnectorDefinitionsAvailabilityResponse):
            ConnectorDefinitionsAvailabilityResponse = ConnectorDefinitionsAvailabilityResponse(
            isPreview = javaType.isPreview().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
