@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions The actions to execute when the automation rule is triggered.
 * @property createdBy Information on the client (user or application) that made some action
 * @property createdTimeUtc The time the automation rule was created.
 * @property displayName The display name of the automation rule.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedBy Information on the client (user or application) that made some action
 * @property lastModifiedTimeUtc The last time the automation rule was updated.
 * @property name The name of the resource
 * @property order The order of execution of the automation rule.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property triggeringLogic Describes automation rule triggering logic.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAutomationRuleResult(
    public val actions:
    List<Either<AutomationRuleModifyPropertiesActionResponse, AutomationRuleRunPlaybookActionResponse>>,
    public val createdBy: ClientInfoResponse,
    public val createdTimeUtc: String,
    public val displayName: String,
    public val etag: String? = null,
    public val id: String,
    public val lastModifiedBy: ClientInfoResponse,
    public val lastModifiedTimeUtc: String,
    public val name: String,
    public val order: Int,
    public val systemData: SystemDataResponse,
    public val triggeringLogic: AutomationRuleTriggeringLogicResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetAutomationRuleResult):
            GetAutomationRuleResult = GetAutomationRuleResult(
            actions = javaType.actions().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleModifyPropertiesActionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleRunPlaybookActionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            createdBy = javaType.createdBy().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin(args0)
            }),
            createdTimeUtc = javaType.createdTimeUtc(),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedBy = javaType.lastModifiedBy().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin(args0)
            }),
            lastModifiedTimeUtc = javaType.lastModifiedTimeUtc(),
            name = javaType.name(),
            order = javaType.order(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            triggeringLogic = javaType.triggeringLogic().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRuleTriggeringLogicResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
