@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a bookmark in Azure Security Insights.
 * @property created The time the bookmark was created
 * @property createdBy Describes a user that created the bookmark
 * @property displayName The display name of the bookmark
 * @property etag Etag of the azure resource
 * @property eventTime The bookmark event time
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property incidentInfo Describes an incident that relates to bookmark
 * @property labels List of labels relevant to this bookmark
 * @property name The name of the resource
 * @property notes The notes of the bookmark
 * @property query The query of the bookmark.
 * @property queryEndTime The end time for the query
 * @property queryResult The query result of the bookmark.
 * @property queryStartTime The start time for the query
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updated The last time the bookmark was updated
 * @property updatedBy Describes a user that updated the bookmark
 */
public data class GetBookmarkResult(
    public val created: String? = null,
    public val createdBy: UserInfoResponse? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val eventTime: String? = null,
    public val id: String,
    public val incidentInfo: IncidentInfoResponse? = null,
    public val labels: List<String>? = null,
    public val name: String,
    public val notes: String? = null,
    public val query: String,
    public val queryEndTime: String? = null,
    public val queryResult: String? = null,
    public val queryStartTime: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updated: String? = null,
    public val updatedBy: UserInfoResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetBookmarkResult):
            GetBookmarkResult = GetBookmarkResult(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            eventTime = javaType.eventTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            incidentInfo = javaType.incidentInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            query = javaType.query(),
            queryEndTime = javaType.queryEndTime().map({ args0 -> args0 }).orElse(null),
            queryResult = javaType.queryResult().map({ args0 -> args0 }).orElse(null),
            queryStartTime = javaType.queryStartTime().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updated = javaType.updated().map({ args0 -> args0 }).orElse(null),
            updatedBy = javaType.updatedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.UserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
