@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a Package in Azure Security Insights.
 * @property author The author of the package
 * @property categories The categories of the package
 * @property contentId The package id
 * @property contentKind The package kind
 * @property contentSchemaVersion The version of the content schema.
 * @property dependencies The support tier of the package
 * @property description The description of the package
 * @property displayName The display name of the package
 * @property etag Etag of the azure resource
 * @property firstPublishDate first publish date package item
 * @property icon the icon identifier. this id can later be fetched from the content metadata
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isFeatured Flag indicates if this package is among the featured list.
 * @property isNew Flag indicates if this is a newly published package.
 * @property isPreview Flag indicates if this package is in preview.
 * @property lastPublishDate last publish date for the package item
 * @property name The name of the resource
 * @property providers Providers for the package item
 * @property publisherDisplayName The publisher display name of the package
 * @property source The source of the package
 * @property support The support tier of the package
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property threatAnalysisTactics the tactics the resource covers
 * @property threatAnalysisTechniques the techniques the resource covers, these have to be aligned with the tactics being used
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version the latest version number of the package
 */
public data class GetContentPackageResult(
    public val author: MetadataAuthorResponse? = null,
    public val categories: MetadataCategoriesResponse? = null,
    public val contentId: String,
    public val contentKind: String,
    public val contentSchemaVersion: String? = null,
    public val dependencies: MetadataDependenciesResponse? = null,
    public val description: String? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val firstPublishDate: String? = null,
    public val icon: String? = null,
    public val id: String,
    public val isFeatured: String? = null,
    public val isNew: String? = null,
    public val isPreview: String? = null,
    public val lastPublishDate: String? = null,
    public val name: String,
    public val providers: List<String>? = null,
    public val publisherDisplayName: String? = null,
    public val source: MetadataSourceResponse? = null,
    public val support: MetadataSupportResponse? = null,
    public val systemData: SystemDataResponse,
    public val threatAnalysisTactics: List<String>? = null,
    public val threatAnalysisTechniques: List<String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetContentPackageResult):
            GetContentPackageResult = GetContentPackageResult(
            author = javaType.author().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            categories = javaType.categories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentId = javaType.contentId(),
            contentKind = javaType.contentKind(),
            contentSchemaVersion = javaType.contentSchemaVersion().map({ args0 -> args0 }).orElse(null),
            dependencies = javaType.dependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            firstPublishDate = javaType.firstPublishDate().map({ args0 -> args0 }).orElse(null),
            icon = javaType.icon().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isFeatured = javaType.isFeatured().map({ args0 -> args0 }).orElse(null),
            isNew = javaType.isNew().map({ args0 -> args0 }).orElse(null),
            isPreview = javaType.isPreview().map({ args0 -> args0 }).orElse(null),
            lastPublishDate = javaType.lastPublishDate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            providers = javaType.providers().map({ args0 -> args0 }),
            publisherDisplayName = javaType.publisherDisplayName().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            support = javaType.support().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            threatAnalysisTactics = javaType.threatAnalysisTactics().map({ args0 -> args0 }),
            threatAnalysisTechniques = javaType.threatAnalysisTechniques().map({ args0 -> args0 }),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
