@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a Watchlist in Azure Security Insights.
 * @property contentType The content type of the raw content. For now, only text/csv is valid
 * @property created The time the watchlist was created
 * @property createdBy Describes a user that created the watchlist
 * @property defaultDuration The default duration of a watchlist (in ISO 8601 duration format)
 * @property description A description of the watchlist
 * @property displayName The display name of the watchlist
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isDeleted A flag that indicates if the watchlist is deleted or not
 * @property itemsSearchKey The search key is used to optimize query performance when using watchlists for joins with other data. For example, enable a column with IP addresses to be the designated SearchKey field, then use this field as the key field when joining to other event data by IP address.
 * @property labels List of labels relevant to this watchlist
 * @property name The name of the resource
 * @property numberOfLinesToSkip The number of lines in a csv content to skip before the header
 * @property provider The provider of the watchlist
 * @property rawContent The raw content that represents to watchlist items to create. Example : This line will be skipped
 * header1,header2
 * value1,value2
 * @property source The source of the watchlist
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tenantId The tenantId where the watchlist belongs to
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updated The last time the watchlist was updated
 * @property updatedBy Describes a user that updated the watchlist
 * @property uploadStatus The status of the Watchlist upload : New, InProgress or Complete. **Note** : When a Watchlist upload status is InProgress, the Watchlist cannot be deleted
 * @property watchlistAlias The alias of the watchlist
 * @property watchlistId The id (a Guid) of the watchlist
 * @property watchlistType The type of the watchlist
 */
public data class GetWatchlistResult(
    public val contentType: String? = null,
    public val created: String? = null,
    public val createdBy: WatchlistUserInfoResponse? = null,
    public val defaultDuration: String? = null,
    public val description: String? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val id: String,
    public val isDeleted: Boolean? = null,
    public val itemsSearchKey: String,
    public val labels: List<String>? = null,
    public val name: String,
    public val numberOfLinesToSkip: Int? = null,
    public val provider: String,
    public val rawContent: String? = null,
    public val source: String,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val type: String,
    public val updated: String? = null,
    public val updatedBy: WatchlistUserInfoResponse? = null,
    public val uploadStatus: String? = null,
    public val watchlistAlias: String? = null,
    public val watchlistId: String? = null,
    public val watchlistType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetWatchlistResult):
            GetWatchlistResult = GetWatchlistResult(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultDuration = javaType.defaultDuration().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isDeleted = javaType.isDeleted().map({ args0 -> args0 }).orElse(null),
            itemsSearchKey = javaType.itemsSearchKey(),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name(),
            numberOfLinesToSkip = javaType.numberOfLinesToSkip().map({ args0 -> args0 }).orElse(null),
            provider = javaType.provider(),
            rawContent = javaType.rawContent().map({ args0 -> args0 }).orElse(null),
            source = javaType.source(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updated = javaType.updated().map({ args0 -> args0 }).orElse(null),
            updatedBy = javaType.updatedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uploadStatus = javaType.uploadStatus().map({ args0 -> args0 }).orElse(null),
            watchlistAlias = javaType.watchlistAlias().map({ args0 -> args0 }).orElse(null),
            watchlistId = javaType.watchlistId().map({ args0 -> args0 }).orElse(null),
            watchlistType = javaType.watchlistType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
