@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Query results for table insights query.
 * @property columns Columns Metadata of the table
 * @property rows Rows data of the table
 */
public data class InsightsTableResultResponse(
    public val columns: List<InsightsTableResultResponseColumns>? = null,
    public val rows: List<List<String>>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.InsightsTableResultResponse):
            InsightsTableResultResponse = InsightsTableResultResponse(
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InsightsTableResultResponseColumns.Companion.toKotlin(args0)
                })
            }),
            rows = javaType.rows().map({ args0 -> args0.map({ args0 -> args0 }) }),
        )
    }
}
