@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an automation rule condition that evaluates a property's value change
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'PropertyChanged'.
 */
public data class PropertyChangedConditionPropertiesResponse(
    public val conditionProperties: AutomationRulePropertyValuesChangedConditionResponse? = null,
    public val conditionType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.PropertyChangedConditionPropertiesResponse):
            PropertyChangedConditionPropertiesResponse = PropertyChangedConditionPropertiesResponse(
            conditionProperties = javaType.conditionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRulePropertyValuesChangedConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conditionType = javaType.conditionType(),
        )
    }
}
