@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an automation rule condition that evaluates a property's value
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'Property'.
 */
public data class PropertyConditionPropertiesResponse(
    public val conditionProperties: AutomationRulePropertyValuesConditionResponse? = null,
    public val conditionType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.PropertyConditionPropertiesResponse):
            PropertyConditionPropertiesResponse = PropertyConditionPropertiesResponse(
            conditionProperties = javaType.conditionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AutomationRulePropertyValuesConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conditionType = javaType.conditionType(),
        )
    }
}
