@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * metadata of a repository.
 * @property branch Branch name of repository.
 * @property deploymentLogsUrl Url to access repository action logs.
 * @property displayUrl Display url of repository.
 * @property pathMapping Dictionary of source control content type and path mapping.
 * @property url Url of repository.
 */
public data class RepositoryResponse(
    public val branch: String? = null,
    public val deploymentLogsUrl: String? = null,
    public val displayUrl: String? = null,
    public val pathMapping: List<ContentPathMapResponse>? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.RepositoryResponse):
            RepositoryResponse = RepositoryResponse(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            deploymentLogsUrl = javaType.deploymentLogsUrl().map({ args0 -> args0 }).orElse(null),
            displayUrl = javaType.displayUrl().map({ args0 -> args0 }).orElse(null),
            pathMapping = javaType.pathMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ContentPathMapResponse.Companion.toKotlin(args0)
                })
            }),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
