@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents security alert timeline item.
 * @property alertType The name of the alert type.
 * @property azureResourceId The alert azure resource id.
 * @property description The alert description.
 * @property displayName The alert name.
 * @property endTimeUtc The alert end time.
 * @property intent The intent of the alert.
 * @property kind The entity query kind
 * Expected value is 'SecurityAlert'.
 * @property productName The alert product name.
 * @property severity The alert severity.
 * @property startTimeUtc The alert start time.
 * @property techniques The techniques of the alert.
 * @property timeGenerated The alert generated time.
 */
public data class SecurityAlertTimelineItemResponse(
    public val alertType: String,
    public val azureResourceId: String,
    public val description: String? = null,
    public val displayName: String,
    public val endTimeUtc: String,
    public val intent: String,
    public val kind: String,
    public val productName: String? = null,
    public val severity: String,
    public val startTimeUtc: String,
    public val techniques: List<String>? = null,
    public val timeGenerated: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.SecurityAlertTimelineItemResponse):
            SecurityAlertTimelineItemResponse = SecurityAlertTimelineItemResponse(
            alertType = javaType.alertType(),
            azureResourceId = javaType.azureResourceId(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            endTimeUtc = javaType.endTimeUtc(),
            intent = javaType.intent(),
            kind = javaType.kind(),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity(),
            startTimeUtc = javaType.startTimeUtc(),
            techniques = javaType.techniques().map({ args0 -> args0 }),
            timeGenerated = javaType.timeGenerated(),
        )
    }
}
