@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes an error encountered in the file during validation.
 * @property errorMessages A list of descriptions of the error.
 * @property recordIndex The number of the record that has the error.
 */
public data class ValidationErrorResponse(
    public val errorMessages: List<String>,
    public val recordIndex: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ValidationErrorResponse):
            ValidationErrorResponse = ValidationErrorResponse(
            errorMessages = javaType.errorMessages().map({ args0 -> args0 }),
            recordIndex = javaType.recordIndex().map({ args0 -> args0 }).orElse(null),
        )
    }
}
