@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User information that made some action
 * @property email The email of the user.
 * @property name The name of the user.
 * @property objectId The object id of the user.
 */
public data class WatchlistUserInfoResponse(
    public val email: String,
    public val name: String,
    public val objectId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.WatchlistUserInfoResponse):
            WatchlistUserInfoResponse = WatchlistUserInfoResponse(
            email = javaType.email(),
            name = javaType.name(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
