@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.serialconsole.kotlin.inputs

import com.pulumi.azurenative.serialconsole.inputs.GetSerialPortPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parentResource The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
 * @property parentResourceType The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
 * @property resourceGroupName The name of the resource group.
 * @property resourceProviderNamespace The namespace of the resource provider.
 * @property serialPort The name of the serial port to connect to.
 */
public data class GetSerialPortPlainArgs(
    public val parentResource: String,
    public val parentResourceType: String,
    public val resourceGroupName: String,
    public val resourceProviderNamespace: String,
    public val serialPort: String,
) : ConvertibleToJava<com.pulumi.azurenative.serialconsole.inputs.GetSerialPortPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.serialconsole.inputs.GetSerialPortPlainArgs =
        com.pulumi.azurenative.serialconsole.inputs.GetSerialPortPlainArgs.builder()
            .parentResource(parentResource.let({ args0 -> args0 }))
            .parentResourceType(parentResourceType.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace.let({ args0 -> args0 }))
            .serialPort(serialPort.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSerialPortPlainArgs].
 */
@PulumiTagMarker
public class GetSerialPortPlainArgsBuilder internal constructor() {
    private var parentResource: String? = null

    private var parentResourceType: String? = null

    private var resourceGroupName: String? = null

    private var resourceProviderNamespace: String? = null

    private var serialPort: String? = null

    /**
     * @param value The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
     */
    @JvmName("nrwekkwrixaxwkld")
    public suspend fun parentResource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResource = mapped
    }

    /**
     * @param value The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
     */
    @JvmName("lppdcnqohqjtgdej")
    public suspend fun parentResourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResourceType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ugfautgwrypokefk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("guvkphioylmsuthh")
    public suspend fun resourceProviderNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The name of the serial port to connect to.
     */
    @JvmName("pafjmfghxpdkpoox")
    public suspend fun serialPort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serialPort = mapped
    }

    internal fun build(): GetSerialPortPlainArgs = GetSerialPortPlainArgs(
        parentResource = parentResource ?: throw PulumiNullFieldException("parentResource"),
        parentResourceType = parentResourceType ?: throw PulumiNullFieldException("parentResourceType"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceProviderNamespace = resourceProviderNamespace ?: throw
            PulumiNullFieldException("resourceProviderNamespace"),
        serialPort = serialPort ?: throw PulumiNullFieldException("serialPort"),
    )
}
