@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NamespaceIpFilterRule].
 */
@PulumiTagMarker
public class NamespaceIpFilterRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceIpFilterRuleArgs = NamespaceIpFilterRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceIpFilterRuleArgsBuilder.() -> Unit) {
        val builder = NamespaceIpFilterRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NamespaceIpFilterRule {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.NamespaceIpFilterRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceIpFilterRule(builtJavaResource)
    }
}

/**
 * Single item in a List or Get IpFilterRules operation
 * Azure REST API version: 2018-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpaceIpFilterRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceIpFilterRule = new AzureNative.ServiceBus.NamespaceIpFilterRule("namespaceIpFilterRule", new()
 *     {
 *         Action = "Accept",
 *         FilterName = "sdk-IPFilterRules-7337",
 *         IpFilterRuleName = "sdk-IPFilterRules-7337",
 *         IpMask = "13.78.143.246/32",
 *         NamespaceName = "sdk-Namespace-5232",
 *         ResourceGroupName = "ResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespaceIpFilterRule(ctx, "namespaceIpFilterRule", &servicebus.NamespaceIpFilterRuleArgs{
 * 			Action:            pulumi.String("Accept"),
 * 			FilterName:        pulumi.String("sdk-IPFilterRules-7337"),
 * 			IpFilterRuleName:  pulumi.String("sdk-IPFilterRules-7337"),
 * 			IpMask:            pulumi.String("13.78.143.246/32"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-5232"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.NamespaceIpFilterRule;
 * import com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceIpFilterRule = new NamespaceIpFilterRule("namespaceIpFilterRule", NamespaceIpFilterRuleArgs.builder()
 *             .action("Accept")
 *             .filterName("sdk-IPFilterRules-7337")
 *             .ipFilterRuleName("sdk-IPFilterRules-7337")
 *             .ipMask("13.78.143.246/32")
 *             .namespaceName("sdk-Namespace-5232")
 *             .resourceGroupName("ResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:NamespaceIpFilterRule sdk-IPFilterRules-7337 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/ipfilterrules/{ipFilterRuleName}
 * ```
 */
public class NamespaceIpFilterRule internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.NamespaceIpFilterRule,
) : KotlinCustomResource(javaResource, NamespaceIpFilterRuleMapper) {
    /**
     * The IP Filter Action
     */
    public val action: Output<String>?
        get() = javaResource.action().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IP Filter name
     */
    public val filterName: Output<String>?
        get() = javaResource.filterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IP Mask
     */
    public val ipMask: Output<String>?
        get() = javaResource.ipMask().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceIpFilterRuleMapper : ResourceMapper<NamespaceIpFilterRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.NamespaceIpFilterRule::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceIpFilterRule =
        NamespaceIpFilterRule(javaResource as com.pulumi.azurenative.servicebus.NamespaceIpFilterRule)
}

/**
 * @see [NamespaceIpFilterRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceIpFilterRule].
 */
public suspend fun namespaceIpFilterRule(
    name: String,
    block: suspend NamespaceIpFilterRuleResourceBuilder.() -> Unit,
): NamespaceIpFilterRule {
    val builder = NamespaceIpFilterRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceIpFilterRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceIpFilterRule(name: String): NamespaceIpFilterRule {
    val builder = NamespaceIpFilterRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
