@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.IPAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get IpFilterRules operation
 * Azure REST API version: 2018-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpaceIpFilterRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceIpFilterRule = new AzureNative.ServiceBus.NamespaceIpFilterRule("namespaceIpFilterRule", new()
 *     {
 *         Action = "Accept",
 *         FilterName = "sdk-IPFilterRules-7337",
 *         IpFilterRuleName = "sdk-IPFilterRules-7337",
 *         IpMask = "13.78.143.246/32",
 *         NamespaceName = "sdk-Namespace-5232",
 *         ResourceGroupName = "ResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespaceIpFilterRule(ctx, "namespaceIpFilterRule", &servicebus.NamespaceIpFilterRuleArgs{
 * 			Action:            pulumi.String("Accept"),
 * 			FilterName:        pulumi.String("sdk-IPFilterRules-7337"),
 * 			IpFilterRuleName:  pulumi.String("sdk-IPFilterRules-7337"),
 * 			IpMask:            pulumi.String("13.78.143.246/32"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-5232"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.NamespaceIpFilterRule;
 * import com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceIpFilterRule = new NamespaceIpFilterRule("namespaceIpFilterRule", NamespaceIpFilterRuleArgs.builder()
 *             .action("Accept")
 *             .filterName("sdk-IPFilterRules-7337")
 *             .ipFilterRuleName("sdk-IPFilterRules-7337")
 *             .ipMask("13.78.143.246/32")
 *             .namespaceName("sdk-Namespace-5232")
 *             .resourceGroupName("ResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:NamespaceIpFilterRule sdk-IPFilterRules-7337 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/ipfilterrules/{ipFilterRuleName}
 * ```
 * @property action The IP Filter Action
 * @property filterName IP Filter name
 * @property ipFilterRuleName The IP Filter Rule name.
 * @property ipMask IP Mask
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class NamespaceIpFilterRuleArgs(
    public val action: Output<Either<String, IPAction>>? = null,
    public val filterName: Output<String>? = null,
    public val ipFilterRuleName: Output<String>? = null,
    public val ipMask: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs =
        com.pulumi.azurenative.servicebus.NamespaceIpFilterRuleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filterName(filterName?.applyValue({ args0 -> args0 }))
            .ipFilterRuleName(ipFilterRuleName?.applyValue({ args0 -> args0 }))
            .ipMask(ipMask?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceIpFilterRuleArgs].
 */
@PulumiTagMarker
public class NamespaceIpFilterRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, IPAction>>? = null

    private var filterName: Output<String>? = null

    private var ipFilterRuleName: Output<String>? = null

    private var ipMask: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The IP Filter Action
     */
    @JvmName("wbxctohfwarlaunp")
    public suspend fun action(`value`: Output<Either<String, IPAction>>) {
        this.action = value
    }

    /**
     * @param value IP Filter name
     */
    @JvmName("twgvjuodaulebbgo")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value The IP Filter Rule name.
     */
    @JvmName("tdkvhegpvtotqnop")
    public suspend fun ipFilterRuleName(`value`: Output<String>) {
        this.ipFilterRuleName = value
    }

    /**
     * @param value IP Mask
     */
    @JvmName("qjpqaenjkhngwddf")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("codjtpgacfivovyf")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("abyqoijxdngodmat")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("kjkgcxhbuindriey")
    public suspend fun action(`value`: Either<String, IPAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("lnasxfxmhjfhfwdk")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The IP Filter Action
     */
    @JvmName("rwgwrdkxunrvmove")
    public fun action(`value`: IPAction) {
        val toBeMapped = Either.ofRight<String, IPAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Filter name
     */
    @JvmName("exyhjymtnbsitrha")
    public suspend fun filterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value The IP Filter Rule name.
     */
    @JvmName("gcuvxkwyjkicymgo")
    public suspend fun ipFilterRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipFilterRuleName = mapped
    }

    /**
     * @param value IP Mask
     */
    @JvmName("xyvjqmbcxaecewft")
    public suspend fun ipMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("pcyqndoannqgylwl")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("mrbkifehdivgywvx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): NamespaceIpFilterRuleArgs = NamespaceIpFilterRuleArgs(
        action = action,
        filterName = filterName,
        ipFilterRuleName = ipFilterRuleName,
        ipMask = ipMask,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
    )
}
