@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NamespaceVirtualNetworkRule].
 */
@PulumiTagMarker
public class NamespaceVirtualNetworkRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceVirtualNetworkRuleArgs = NamespaceVirtualNetworkRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceVirtualNetworkRuleArgsBuilder.() -> Unit) {
        val builder = NamespaceVirtualNetworkRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NamespaceVirtualNetworkRule {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceVirtualNetworkRule(builtJavaResource)
    }
}

/**
 * Single item in a List or Get VirtualNetworkRules operation
 * Azure REST API version: 2018-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpaceVirtualNetworkRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceVirtualNetworkRule = new AzureNative.ServiceBus.NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", new()
 *     {
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRuleName = "sdk-VirtualNetworkRules-9191",
 *         VirtualNetworkSubnetId = "/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespaceVirtualNetworkRule(ctx, "namespaceVirtualNetworkRule", &servicebus.NamespaceVirtualNetworkRuleArgs{
 * 			NamespaceName:          pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName:      pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRuleName: pulumi.String("sdk-VirtualNetworkRules-9191"),
 * 			VirtualNetworkSubnetId: pulumi.String("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule;
 * import com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceVirtualNetworkRule = new NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", NamespaceVirtualNetworkRuleArgs.builder()
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRuleName("sdk-VirtualNetworkRules-9191")
 *             .virtualNetworkSubnetId("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:NamespaceVirtualNetworkRule sdk-VirtualNetworkRules-9191 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/virtualnetworkrules/{virtualNetworkRuleName}
 * ```
 */
public class NamespaceVirtualNetworkRule internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule,
) : KotlinCustomResource(javaResource, NamespaceVirtualNetworkRuleMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Resource ID of Virtual Network Subnet
     */
    public val virtualNetworkSubnetId: Output<String>?
        get() = javaResource.virtualNetworkSubnetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NamespaceVirtualNetworkRuleMapper : ResourceMapper<NamespaceVirtualNetworkRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceVirtualNetworkRule =
        NamespaceVirtualNetworkRule(
            javaResource as
                com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule,
        )
}

/**
 * @see [NamespaceVirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceVirtualNetworkRule].
 */
public suspend fun namespaceVirtualNetworkRule(
    name: String,
    block: suspend NamespaceVirtualNetworkRuleResourceBuilder.() -> Unit,
):
    NamespaceVirtualNetworkRule {
    val builder = NamespaceVirtualNetworkRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceVirtualNetworkRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceVirtualNetworkRule(name: String): NamespaceVirtualNetworkRule {
    val builder = NamespaceVirtualNetworkRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
