@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.EndPointProvisioningState
import com.pulumi.azurenative.servicebus.kotlin.inputs.ConnectionStateArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ConnectionStateArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.PrivateEndpointArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.PrivateEndpointArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the PrivateEndpointConnection.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### NameSpacePrivateEndPointConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.ServiceBus.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         NamespaceName = "sdk-Namespace-2924",
 *         PrivateEndpoint = new AzureNative.ServiceBus.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/dbedb4e0-40e6-4145-81f3-f1314c150774/resourceGroups/SDK-ServiceBus-8396/providers/Microsoft.Network/privateEndpoints/sdk-Namespace-2847",
 *         },
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         PrivateLinkServiceConnectionState = new AzureNative.ServiceBus.Inputs.ConnectionStateArgs
 *         {
 *             Description = "testing",
 *             Status = "Rejected",
 *         },
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ArunMonocle",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &servicebus.PrivateEndpointConnectionArgs{
 * 			NamespaceName: pulumi.String("sdk-Namespace-2924"),
 * 			PrivateEndpoint: &servicebus.PrivateEndpointArgs{
 * 				Id: pulumi.String("/subscriptions/dbedb4e0-40e6-4145-81f3-f1314c150774/resourceGroups/SDK-ServiceBus-8396/providers/Microsoft.Network/privateEndpoints/sdk-Namespace-2847"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			PrivateLinkServiceConnectionState: &servicebus.ConnectionStateArgs{
 * 				Description: pulumi.String("testing"),
 * 				Status:      pulumi.String("Rejected"),
 * 			},
 * 			ProvisioningState: pulumi.String("Succeeded"),
 * 			ResourceGroupName: pulumi.String("ArunMonocle"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.PrivateEndpointConnection;
 * import com.pulumi.azurenative.servicebus.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .namespaceName("sdk-Namespace-2924")
 *             .privateEndpoint(Map.of("id", "/subscriptions/dbedb4e0-40e6-4145-81f3-f1314c150774/resourceGroups/SDK-ServiceBus-8396/providers/Microsoft.Network/privateEndpoints/sdk-Namespace-2847"))
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "testing"),
 *                 Map.entry("status", "Rejected")
 *             ))
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ArunMonocle")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:PrivateEndpointConnection 928c44d5-b7c6-423b-b6fa-811e0c27b3e0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property namespaceName The namespace name
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateEndpointConnectionName The PrivateEndpointConnection name
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class PrivateEndpointConnectionArgs(
    public val namespaceName: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, EndPointProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.servicebus.PrivateEndpointConnectionArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, EndPointProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The namespace name
     */
    @JvmName("qwcvyyygfrcnddok")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("amjjmalldfuxdble")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The PrivateEndpointConnection name
     */
    @JvmName("meirfiqhmnggobxn")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("pntcpvtnmoprufny")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("lsbgtnfwykcecpbx")
    public suspend fun provisioningState(`value`: Output<Either<String, EndPointProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cetrxkemijjmmtbx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("jualgsrguhfhqogb")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("wpyaghemnnrkymxa")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The Private Endpoint resource for this Connection.
     */
    @JvmName("dpnmopaaqjnfokpo")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The PrivateEndpointConnection name
     */
    @JvmName("grpkhunnaxhnnsjv")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("wviohtfstcscwrab")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Details about the state of the connection.
     */
    @JvmName("eplcxjrctreekums")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("hybsquyksoeefqjb")
    public suspend fun provisioningState(`value`: Either<String, EndPointProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("mqioydgoqyxeooyj")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndPointProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("xawsyrtgwhkelbvt")
    public fun provisioningState(`value`: EndPointProvisioningState) {
        val toBeMapped = Either.ofRight<String, EndPointProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("emvxdynwenryylrg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        namespaceName = namespaceName,
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
