@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the Private Endpoint Connection.
 */
public enum class EndPointProvisioningState(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState> {
    Creating(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Creating),
    Updating(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Succeeded),
    Canceled(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.EndPointProvisioningState):
            EndPointProvisioningState =
            EndPointProvisioningState.values().first { it.javaValue == javaType }
    }
}
