@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Filter type that is evaluated against a BrokeredMessage.
 */
public enum class FilterType(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.FilterType,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.FilterType> {
    SqlFilter(com.pulumi.azurenative.servicebus.enums.FilterType.SqlFilter),
    CorrelationFilter(com.pulumi.azurenative.servicebus.enums.FilterType.CorrelationFilter),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.FilterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.FilterType): FilterType =
            FilterType.values().first { it.javaValue == javaType }
    }
}
