@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.ActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
 * @property compatibilityLevel This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
 * @property requiresPreprocessing Value that indicates whether the rule action requires preprocessing.
 * @property sqlExpression SQL expression. e.g. MyProperty='ABC'
 */
public data class ActionArgs(
    public val compatibilityLevel: Output<Int>? = null,
    public val requiresPreprocessing: Output<Boolean>? = null,
    public val sqlExpression: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.ActionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.ActionArgs =
        com.pulumi.azurenative.servicebus.inputs.ActionArgs.builder()
            .compatibilityLevel(compatibilityLevel?.applyValue({ args0 -> args0 }))
            .requiresPreprocessing(requiresPreprocessing?.applyValue({ args0 -> args0 }))
            .sqlExpression(sqlExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActionArgs].
 */
@PulumiTagMarker
public class ActionArgsBuilder internal constructor() {
    private var compatibilityLevel: Output<Int>? = null

    private var requiresPreprocessing: Output<Boolean>? = null

    private var sqlExpression: Output<String>? = null

    /**
     * @param value This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
     */
    @JvmName("vyyhrymhvwdkphxg")
    public suspend fun compatibilityLevel(`value`: Output<Int>) {
        this.compatibilityLevel = value
    }

    /**
     * @param value Value that indicates whether the rule action requires preprocessing.
     */
    @JvmName("fiedgccldeatufuy")
    public suspend fun requiresPreprocessing(`value`: Output<Boolean>) {
        this.requiresPreprocessing = value
    }

    /**
     * @param value SQL expression. e.g. MyProperty='ABC'
     */
    @JvmName("cvwtkweqiovdnmxa")
    public suspend fun sqlExpression(`value`: Output<String>) {
        this.sqlExpression = value
    }

    /**
     * @param value This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
     */
    @JvmName("pbjjivwwiujsndlp")
    public suspend fun compatibilityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibilityLevel = mapped
    }

    /**
     * @param value Value that indicates whether the rule action requires preprocessing.
     */
    @JvmName("aiohtefpcomklitt")
    public suspend fun requiresPreprocessing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresPreprocessing = mapped
    }

    /**
     * @param value SQL expression. e.g. MyProperty='ABC'
     */
    @JvmName("oexjiimiqcjlqngt")
    public suspend fun sqlExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlExpression = mapped
    }

    internal fun build(): ActionArgs = ActionArgs(
        compatibilityLevel = compatibilityLevel,
        requiresPreprocessing = requiresPreprocessing,
        sqlExpression = sqlExpression,
    )
}
