@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetDisasterRecoveryConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The Disaster Recovery configuration name
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetDisasterRecoveryConfigPlainArgs(
    public val alias: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetDisasterRecoveryConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetDisasterRecoveryConfigPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetDisasterRecoveryConfigPlainArgs.builder()
            .alias(alias.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDisasterRecoveryConfigPlainArgs].
 */
@PulumiTagMarker
public class GetDisasterRecoveryConfigPlainArgsBuilder internal constructor() {
    private var alias: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Disaster Recovery configuration name
     */
    @JvmName("qxdpdmxpqyeehhvo")
    public suspend fun alias(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.alias = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("nnvfnrovnimrflmb")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ppvpuqcvyqgvwirf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDisasterRecoveryConfigPlainArgs = GetDisasterRecoveryConfigPlainArgs(
        alias = alias ?: throw PulumiNullFieldException("alias"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
