@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetNamespaceNetworkRuleSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetNamespaceNetworkRuleSetPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetNamespaceNetworkRuleSetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicebus.inputs.GetNamespaceNetworkRuleSetPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetNamespaceNetworkRuleSetPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceNetworkRuleSetPlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceNetworkRuleSetPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("hxneycmaghoyxyoc")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cjgupximnfavfrmc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNamespaceNetworkRuleSetPlainArgs = GetNamespaceNetworkRuleSetPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
