@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetNamespacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetNamespacePlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetNamespacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetNamespacePlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetNamespacePlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespacePlainArgs].
 */
@PulumiTagMarker
public class GetNamespacePlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("gthsxjiuhhfpmobi")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wlmnuglwxjjekphb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNamespacePlainArgs = GetNamespacePlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
