@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetQueuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property queueName The queue name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetQueuePlainArgs(
    public val namespaceName: String,
    public val queueName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetQueuePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetQueuePlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetQueuePlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .queueName(queueName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueuePlainArgs].
 */
@PulumiTagMarker
public class GetQueuePlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var queueName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("gsawhhyqljqraqlv")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The queue name.
     */
    @JvmName("dcxhwxsnqnawurfk")
    public suspend fun queueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queueName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hxemyilbcadfpmsd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetQueuePlainArgs = GetQueuePlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        queueName = queueName ?: throw PulumiNullFieldException("queueName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
