@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property topicName The topic name.
 */
public data class GetTopicPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetTopicPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetTopicPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetTopicPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicPlainArgs].
 */
@PulumiTagMarker
public class GetTopicPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("fgxhbiqtaevtnksg")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("rwjcrlotivkuewhh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("sgpxkpeawxydvtgm")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetTopicPlainArgs = GetTopicPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
