@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.ListDisasterRecoveryConfigKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The Disaster Recovery configuration name
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class ListDisasterRecoveryConfigKeysPlainArgs(
    public val alias: String,
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.ListDisasterRecoveryConfigKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicebus.inputs.ListDisasterRecoveryConfigKeysPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.ListDisasterRecoveryConfigKeysPlainArgs.builder()
            .alias(alias.let({ args0 -> args0 }))
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDisasterRecoveryConfigKeysPlainArgs].
 */
@PulumiTagMarker
public class ListDisasterRecoveryConfigKeysPlainArgsBuilder internal constructor() {
    private var alias: String? = null

    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Disaster Recovery configuration name
     */
    @JvmName("qpielacdhhnmgpnv")
    public suspend fun alias(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.alias = mapped
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("lqusaurstxnkwrnq")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("nceqvdlphiwsaxwm")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wpdoohpsbjtnajnf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDisasterRecoveryConfigKeysPlainArgs =
        ListDisasterRecoveryConfigKeysPlainArgs(
            alias = alias ?: throw PulumiNullFieldException("alias"),
            authorizationRuleName = authorizationRuleName ?: throw
                PulumiNullFieldException("authorizationRuleName"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
