@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.SubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties supplied for Subnet
 * @property id Resource ID of Virtual Network Subnet
 */
public data class SubnetArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.SubnetArgs =
        com.pulumi.azurenative.servicebus.inputs.SubnetArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of Virtual Network Subnet
     */
    @JvmName("pnhlltjkwuiaiqxb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of Virtual Network Subnet
     */
    @JvmName("cbyoywgnlmljirix")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
