@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of queue Resource.
 * @property accessedAt Last time a message was sent, or the last time there was a receive request to this queue.
 * @property autoDeleteOnIdle ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
 * @property countDetails Message Count Details.
 * @property createdAt The exact time the message was created.
 * @property deadLetteringOnMessageExpiration A value that indicates whether this queue has dead letter support when a message expires.
 * @property defaultMessageTimeToLive ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property enableExpress A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
 * @property enablePartitioning A value that indicates whether the queue is to be partitioned across multiple message brokers.
 * @property forwardDeadLetteredMessagesTo Queue/Topic name to forward the Dead Letter message
 * @property forwardTo Queue/Topic name to forward the messages
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property lockDuration ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
 * @property maxDeliveryCount The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
 * @property maxMessageSizeInKilobytes Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024.
 * @property maxSizeInMegabytes The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
 * @property messageCount The number of messages in the queue.
 * @property name The name of the resource
 * @property requiresDuplicateDetection A value indicating if this queue requires duplicate detection.
 * @property requiresSession A value that indicates whether the queue supports the concept of sessions.
 * @property sizeInBytes The size of the queue, in bytes.
 * @property status Enumerates the possible values for the status of a messaging entity.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The exact time the message was updated.
 */
public data class GetQueueResult(
    public val accessedAt: String,
    public val autoDeleteOnIdle: String? = null,
    public val countDetails: MessageCountDetailsResponse,
    public val createdAt: String,
    public val deadLetteringOnMessageExpiration: Boolean? = null,
    public val defaultMessageTimeToLive: String? = null,
    public val duplicateDetectionHistoryTimeWindow: String? = null,
    public val enableBatchedOperations: Boolean? = null,
    public val enableExpress: Boolean? = null,
    public val enablePartitioning: Boolean? = null,
    public val forwardDeadLetteredMessagesTo: String? = null,
    public val forwardTo: String? = null,
    public val id: String,
    public val location: String,
    public val lockDuration: String? = null,
    public val maxDeliveryCount: Int? = null,
    public val maxMessageSizeInKilobytes: Double? = null,
    public val maxSizeInMegabytes: Int? = null,
    public val messageCount: Double,
    public val name: String,
    public val requiresDuplicateDetection: Boolean? = null,
    public val requiresSession: Boolean? = null,
    public val sizeInBytes: Double,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetQueueResult):
            GetQueueResult = GetQueueResult(
            accessedAt = javaType.accessedAt(),
            autoDeleteOnIdle = javaType.autoDeleteOnIdle().map({ args0 -> args0 }).orElse(null),
            countDetails = javaType.countDetails().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse.Companion.toKotlin(args0)
            }),
            createdAt = javaType.createdAt(),
            deadLetteringOnMessageExpiration = javaType.deadLetteringOnMessageExpiration().map({ args0 ->
                args0
            }).orElse(null),
            defaultMessageTimeToLive = javaType.defaultMessageTimeToLive().map({ args0 -> args0 }).orElse(null),
            duplicateDetectionHistoryTimeWindow = javaType.duplicateDetectionHistoryTimeWindow().map({ args0 ->
                args0
            }).orElse(null),
            enableBatchedOperations = javaType.enableBatchedOperations().map({ args0 -> args0 }).orElse(null),
            enableExpress = javaType.enableExpress().map({ args0 -> args0 }).orElse(null),
            enablePartitioning = javaType.enablePartitioning().map({ args0 -> args0 }).orElse(null),
            forwardDeadLetteredMessagesTo = javaType.forwardDeadLetteredMessagesTo().map({ args0 ->
                args0
            }).orElse(null),
            forwardTo = javaType.forwardTo().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            lockDuration = javaType.lockDuration().map({ args0 -> args0 }).orElse(null),
            maxDeliveryCount = javaType.maxDeliveryCount().map({ args0 -> args0 }).orElse(null),
            maxMessageSizeInKilobytes = javaType.maxMessageSizeInKilobytes().map({ args0 ->
                args0
            }).orElse(null),
            maxSizeInMegabytes = javaType.maxSizeInMegabytes().map({ args0 -> args0 }).orElse(null),
            messageCount = javaType.messageCount(),
            name = javaType.name(),
            requiresDuplicateDetection = javaType.requiresDuplicateDetection().map({ args0 ->
                args0
            }).orElse(null),
            requiresSession = javaType.requiresSession().map({ args0 -> args0 }).orElse(null),
            sizeInBytes = javaType.sizeInBytes(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
