@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of Rule Resource.
 * @property action Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
 * @property correlationFilter Properties of correlationFilter
 * @property filterType Filter type that is evaluated against a BrokeredMessage.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property sqlFilter Properties of sqlFilter
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 */
public data class GetRuleResult(
    public val action: ActionResponse? = null,
    public val correlationFilter: CorrelationFilterResponse? = null,
    public val filterType: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val sqlFilter: SqlFilterResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetRuleResult):
            GetRuleResult = GetRuleResult(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.ActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            correlationFilter = javaType.correlationFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.CorrelationFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filterType = javaType.filterType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sqlFilter = javaType.sqlFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.SqlFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
