@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.kotlin.outputs.EndpointRangeDescriptionResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.FrontendConfigurationResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.NetworkSecurityRuleResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.NodeTypeSkuResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VMSSExtensionResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VaultSecretGroupResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmImagePlanResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmManagedIdentityResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmssDataDiskResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicefabric.kotlin.outputs.EndpointRangeDescriptionResponse.Companion.toKotlin as endpointRangeDescriptionResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.FrontendConfigurationResponse.Companion.toKotlin as frontendConfigurationResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.NetworkSecurityRuleResponse.Companion.toKotlin as networkSecurityRuleResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.NodeTypeSkuResponse.Companion.toKotlin as nodeTypeSkuResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VMSSExtensionResponse.Companion.toKotlin as vMSSExtensionResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VaultSecretGroupResponse.Companion.toKotlin as vaultSecretGroupResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmImagePlanResponse.Companion.toKotlin as vmImagePlanResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmManagedIdentityResponse.Companion.toKotlin as vmManagedIdentityResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.VmssDataDiskResponse.Companion.toKotlin as vmssDataDiskResponseToKotlin

/**
 * Builder for [NodeType].
 */
@PulumiTagMarker
public class NodeTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NodeTypeArgs = NodeTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NodeTypeArgsBuilder.() -> Unit) {
        val builder = NodeTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NodeType {
        val builtJavaResource = com.pulumi.azurenative.servicefabric.NodeType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NodeType(builtJavaResource)
    }
}

/**
 * Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2021-09-01-privatepreview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Put a node type with auto-scale parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         Capacities =
 *         {
 *             { "ClientConnections", "65536" },
 *         },
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = "Premium_LRS",
 *         IsPrimary = false,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NodeTypeName = "BE",
 *         PlacementProperties =
 *         {
 *             { "HasSSD", "true" },
 *             { "NodeColor", "green" },
 *             { "SomeProperty", "5" },
 *         },
 *         ResourceGroupName = "resRg",
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = -1,
 *         VmManagedIdentity = new AzureNative.ServiceFabric.Inputs.VmManagedIdentityArgs
 *         {
 *             UserAssignedIdentities = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2",
 *             },
 *         },
 *         VmSecrets = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VaultSecretGroupArgs
 *             {
 *                 SourceVault = new AzureNative.ServiceFabric.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault",
 *                 },
 *                 VaultCertificates = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.VaultCertificateArgs
 *                     {
 *                         CertificateStore = "My",
 *                         CertificateUrl = "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c",
 *                     },
 *                 },
 *             },
 *         },
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			Capacities: pulumi.StringMap{
 * 				"ClientConnections": pulumi.String("65536"),
 * 			},
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			DataDiskSizeGB:          pulumi.Int(200),
 * 			DataDiskType:            pulumi.String("Premium_LRS"),
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			PlacementProperties: pulumi.StringMap{
 * 				"HasSSD":       pulumi.String("true"),
 * 				"NodeColor":    pulumi.String("green"),
 * 				"SomeProperty": pulumi.String("5"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmExtensions: []servicefabric.VMSSExtensionArgs{
 * 				{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                nil,
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  -1,
 * 			VmManagedIdentity: &servicefabric.VmManagedIdentityArgs{
 * 				UserAssignedIdentities: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity"),
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"),
 * 				},
 * 			},
 * 			VmSecrets: []servicefabric.VaultSecretGroupArgs{
 * 				{
 * 					SourceVault: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault"),
 * 					},
 * 					VaultCertificates: servicefabric.VaultCertificateArray{
 * 						{
 * 							CertificateStore: pulumi.String("My"),
 * 							CertificateUrl:   pulumi.String("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmSize: pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .capacities(Map.of("ClientConnections", "65536"))
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("Premium_LRS")
 *             .isPrimary(false)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .nodeTypeName("BE")
 *             .placementProperties(Map.ofEntries(
 *                 Map.entry("HasSSD", "true"),
 *                 Map.entry("NodeColor", "green"),
 *                 Map.entry("SomeProperty", "5")
 *             ))
 *             .resourceGroupName("resRg")
 *             .vmExtensions(Map.ofEntries(
 *                 Map.entry("autoUpgradeMinorVersion", true),
 *                 Map.entry("name", "Microsoft.Azure.Geneva.GenevaMonitoring"),
 *                 Map.entry("publisher", "Microsoft.Azure.Geneva"),
 *                 Map.entry("settings", ),
 *                 Map.entry("type", "GenevaMonitoring"),
 *                 Map.entry("typeHandlerVersion", "2.0")
 *             ))
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount("TODO: GenUnaryOpExpression")
 *             .vmManagedIdentity(Map.of("userAssignedIdentities",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"))
 *             .vmSecrets(Map.ofEntries(
 *                 Map.entry("sourceVault", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault")),
 *                 Map.entry("vaultCertificates", Map.ofEntries(
 *                     Map.entry("certificateStore", "My"),
 *                     Map.entry("certificateUrl", "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c")
 *                 ))
 *             ))
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a node type with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         AdditionalDataDisks = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VmssDataDiskArgs
 *             {
 *                 DiskLetter = "F",
 *                 DiskSizeGB = 256,
 *                 DiskType = "StandardSSD_LRS",
 *                 Lun = 1,
 *             },
 *             new AzureNative.ServiceFabric.Inputs.VmssDataDiskArgs
 *             {
 *                 DiskLetter = "G",
 *                 DiskSizeGB = 150,
 *                 DiskType = "Premium_LRS",
 *                 Lun = 2,
 *             },
 *         },
 *         Capacities =
 *         {
 *             { "ClientConnections", "65536" },
 *         },
 *         ClusterName = "myCluster",
 *         DataDiskLetter = "S",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = "Premium_LRS",
 *         EnableAcceleratedNetworking = true,
 *         EnableEncryptionAtHost = true,
 *         EnableNodePublicIP = true,
 *         EnableOverProvisioning = false,
 *         EvictionPolicy = "Deallocate",
 *         FrontendConfigurations = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.FrontendConfigurationArgs
 *             {
 *                 ApplicationGatewayBackendAddressPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest",
 *                 LoadBalancerBackendAddressPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool",
 *                 LoadBalancerInboundNatPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool",
 *             },
 *         },
 *         IsPrimary = false,
 *         IsSpotVM = true,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NatGatewayId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway",
 *         NodeTypeName = "BE",
 *         PlacementProperties =
 *         {
 *             { "HasSSD", "true" },
 *             { "NodeColor", "green" },
 *             { "SomeProperty", "5" },
 *         },
 *         ResourceGroupName = "resRg",
 *         SecureBootEnabled = true,
 *         SecurityType = "TrustedLaunch",
 *         SpotRestoreTimeout = "PT30M",
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         UseDefaultPublicLoadBalancer = true,
 *         UseEphemeralOSDisk = true,
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 EnableAutomaticUpgrade = true,
 *                 ForceUpdateTag = "v.1.0",
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmManagedIdentity = new AzureNative.ServiceFabric.Inputs.VmManagedIdentityArgs
 *         {
 *             UserAssignedIdentities = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2",
 *             },
 *         },
 *         VmSecrets = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VaultSecretGroupArgs
 *             {
 *                 SourceVault = new AzureNative.ServiceFabric.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault",
 *                 },
 *                 VaultCertificates = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.VaultCertificateArgs
 *                     {
 *                         CertificateStore = "My",
 *                         CertificateUrl = "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c",
 *                     },
 *                 },
 *             },
 *         },
 *         VmSetupActions = new[]
 *         {
 *             "EnableContainers",
 *             "EnableHyperV",
 *         },
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			AdditionalDataDisks: []servicefabric.VmssDataDiskArgs{
 * 				{
 * 					DiskLetter: pulumi.String("F"),
 * 					DiskSizeGB: pulumi.Int(256),
 * 					DiskType:   pulumi.String("StandardSSD_LRS"),
 * 					Lun:        pulumi.Int(1),
 * 				},
 * 				{
 * 					DiskLetter: pulumi.String("G"),
 * 					DiskSizeGB: pulumi.Int(150),
 * 					DiskType:   pulumi.String("Premium_LRS"),
 * 					Lun:        pulumi.Int(2),
 * 				},
 * 			},
 * 			Capacities: pulumi.StringMap{
 * 				"ClientConnections": pulumi.String("65536"),
 * 			},
 * 			ClusterName:                 pulumi.String("myCluster"),
 * 			DataDiskLetter:              pulumi.String("S"),
 * 			DataDiskSizeGB:              pulumi.Int(200),
 * 			DataDiskType:                pulumi.String("Premium_LRS"),
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			EnableEncryptionAtHost:      pulumi.Bool(true),
 * 			EnableNodePublicIP:          pulumi.Bool(true),
 * 			EnableOverProvisioning:      pulumi.Bool(false),
 * 			EvictionPolicy:              pulumi.String("Deallocate"),
 * 			FrontendConfigurations: []servicefabric.FrontendConfigurationArgs{
 * 				{
 * 					ApplicationGatewayBackendAddressPoolId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest"),
 * 					LoadBalancerBackendAddressPoolId:       pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool"),
 * 					LoadBalancerInboundNatPoolId:           pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool"),
 * 				},
 * 			},
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsSpotVM:                pulumi.Bool(true),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NatGatewayId:            pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway"),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			PlacementProperties: pulumi.StringMap{
 * 				"HasSSD":       pulumi.String("true"),
 * 				"NodeColor":    pulumi.String("green"),
 * 				"SomeProperty": pulumi.String("5"),
 * 			},
 * 			ResourceGroupName:            pulumi.String("resRg"),
 * 			SecureBootEnabled:            pulumi.Bool(true),
 * 			SecurityType:                 pulumi.String("TrustedLaunch"),
 * 			SpotRestoreTimeout:           pulumi.String("PT30M"),
 * 			SubnetId:                     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			UseDefaultPublicLoadBalancer: pulumi.Bool(true),
 * 			UseEphemeralOSDisk:           pulumi.Bool(true),
 * 			VmExtensions: []servicefabric.VMSSExtensionArgs{
 * 				{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 					ForceUpdateTag:          pulumi.String("v.1.0"),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                nil,
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmManagedIdentity: &servicefabric.VmManagedIdentityArgs{
 * 				UserAssignedIdentities: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity"),
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"),
 * 				},
 * 			},
 * 			VmSecrets: []servicefabric.VaultSecretGroupArgs{
 * 				{
 * 					SourceVault: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault"),
 * 					},
 * 					VaultCertificates: servicefabric.VaultCertificateArray{
 * 						{
 * 							CertificateStore: pulumi.String("My"),
 * 							CertificateUrl:   pulumi.String("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmSetupActions: pulumi.StringArray{
 * 				pulumi.String("EnableContainers"),
 * 				pulumi.String("EnableHyperV"),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .additionalDataDisks(
 *                 Map.ofEntries(
 *                     Map.entry("diskLetter", "F"),
 *                     Map.entry("diskSizeGB", 256),
 *                     Map.entry("diskType", "StandardSSD_LRS"),
 *                     Map.entry("lun", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("diskLetter", "G"),
 *                     Map.entry("diskSizeGB", 150),
 *                     Map.entry("diskType", "Premium_LRS"),
 *                     Map.entry("lun", 2)
 *                 ))
 *             .capacities(Map.of("ClientConnections", "65536"))
 *             .clusterName("myCluster")
 *             .dataDiskLetter("S")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("Premium_LRS")
 *             .enableAcceleratedNetworking(true)
 *             .enableEncryptionAtHost(true)
 *             .enableNodePublicIP(true)
 *             .enableOverProvisioning(false)
 *             .evictionPolicy("Deallocate")
 *             .frontendConfigurations(Map.ofEntries(
 *                 Map.entry("applicationGatewayBackendAddressPoolId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest"),
 *                 Map.entry("loadBalancerBackendAddressPoolId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool"),
 *                 Map.entry("loadBalancerInboundNatPoolId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool")
 *             ))
 *             .isPrimary(false)
 *             .isSpotVM(true)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .natGatewayId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway")
 *             .nodeTypeName("BE")
 *             .placementProperties(Map.ofEntries(
 *                 Map.entry("HasSSD", "true"),
 *                 Map.entry("NodeColor", "green"),
 *                 Map.entry("SomeProperty", "5")
 *             ))
 *             .resourceGroupName("resRg")
 *             .secureBootEnabled(true)
 *             .securityType("TrustedLaunch")
 *             .spotRestoreTimeout("PT30M")
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .useDefaultPublicLoadBalancer(true)
 *             .useEphemeralOSDisk(true)
 *             .vmExtensions(Map.ofEntries(
 *                 Map.entry("autoUpgradeMinorVersion", true),
 *                 Map.entry("enableAutomaticUpgrade", true),
 *                 Map.entry("forceUpdateTag", "v.1.0"),
 *                 Map.entry("name", "Microsoft.Azure.Geneva.GenevaMonitoring"),
 *                 Map.entry("publisher", "Microsoft.Azure.Geneva"),
 *                 Map.entry("settings", ),
 *                 Map.entry("type", "GenevaMonitoring"),
 *                 Map.entry("typeHandlerVersion", "2.0")
 *             ))
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmManagedIdentity(Map.of("userAssignedIdentities",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"))
 *             .vmSecrets(Map.ofEntries(
 *                 Map.entry("sourceVault", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault")),
 *                 Map.entry("vaultCertificates", Map.ofEntries(
 *                     Map.entry("certificateStore", "My"),
 *                     Map.entry("certificateUrl", "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c")
 *                 ))
 *             ))
 *             .vmSetupActions(
 *                 "EnableContainers",
 *                 "EnableHyperV")
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a node type with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageOffer:      pulumi.String("WindowsServer"),
 * 			VmImagePublisher:  pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:        pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:    pulumi.String("latest"),
 * 			VmInstanceCount:   pulumi.Int(10),
 * 			VmSize:            pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put an stateless node type with temporary disk for service fabric
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         EnableEncryptionAtHost = true,
 *         IsPrimary = false,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         UseTempDataDisk = true,
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			EnableEncryptionAtHost:  pulumi.Bool(true),
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			ResourceGroupName:       pulumi.String("resRg"),
 * 			UseTempDataDisk:         pulumi.Bool(true),
 * 			VmExtensions: []servicefabric.VMSSExtensionArgs{
 * 				{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                nil,
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmSize:           pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .enableEncryptionAtHost(true)
 *             .isPrimary(false)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .useTempDataDisk(true)
 *             .vmExtensions(Map.ofEntries(
 *                 Map.entry("autoUpgradeMinorVersion", true),
 *                 Map.entry("name", "Microsoft.Azure.Geneva.GenevaMonitoring"),
 *                 Map.entry("publisher", "Microsoft.Azure.Geneva"),
 *                 Map.entry("settings", ),
 *                 Map.entry("type", "GenevaMonitoring"),
 *                 Map.entry("typeHandlerVersion", "2.0")
 *             ))
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with custom vm image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC"),
 * 			VmInstanceCount:   pulumi.Int(10),
 * 			VmSize:            pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with dedicated hosts
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         Capacities = null,
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = "StandardSSD_LRS",
 *         HostGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup",
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         PlacementProperties = null,
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2019-Datacenter",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D8s_v3",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			Capacities:          nil,
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			DataDiskSizeGB:      pulumi.Int(200),
 * 			DataDiskType:        pulumi.String("StandardSSD_LRS"),
 * 			HostGroupId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup"),
 * 			IsPrimary:           pulumi.Bool(false),
 * 			NodeTypeName:        pulumi.String("BE"),
 * 			PlacementProperties: nil,
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			VmImageOffer:        pulumi.String("WindowsServer"),
 * 			VmImagePublisher:    pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:          pulumi.String("2019-Datacenter"),
 * 			VmImageVersion:      pulumi.String("latest"),
 * 			VmInstanceCount:     pulumi.Int(10),
 * 			VmSize:              pulumi.String("Standard_D8s_v3"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .capacities()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("StandardSSD_LRS")
 *             .hostGroupId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup")
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .placementProperties()
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2019-Datacenter")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D8s_v3")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with shared galleries custom vm image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmInstanceCount = 10,
 *         VmSharedGalleryImageId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest",
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:            pulumi.String("myCluster"),
 * 			DataDiskSizeGB:         pulumi.Int(200),
 * 			IsPrimary:              pulumi.Bool(false),
 * 			NodeTypeName:           pulumi.String("BE"),
 * 			ResourceGroupName:      pulumi.String("resRg"),
 * 			VmInstanceCount:        pulumi.Int(10),
 * 			VmSharedGalleryImageId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest"),
 * 			VmSize:                 pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmInstanceCount(10)
 *             .vmSharedGalleryImageId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest")
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with vm image plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "windows_2022_test",
 *         VmImagePlan = new AzureNative.ServiceFabric.Inputs.VmImagePlanArgs
 *         {
 *             Name = "win_2022_test_20_10_gen2",
 *             Product = "windows_2022_test",
 *             Publisher = "testpublisher",
 *         },
 *         VmImagePublisher = "testpublisher",
 *         VmImageSku = "win_2022_test_20_10_gen2",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageOffer:      pulumi.String("windows_2022_test"),
 * 			VmImagePlan: &servicefabric.VmImagePlanArgs{
 * 				Name:      pulumi.String("win_2022_test_20_10_gen2"),
 * 				Product:   pulumi.String("windows_2022_test"),
 * 				Publisher: pulumi.String("testpublisher"),
 * 			},
 * 			VmImagePublisher: pulumi.String("testpublisher"),
 * 			VmImageSku:       pulumi.String("win_2022_test_20_10_gen2"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmSize:           pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("windows_2022_test")
 *             .vmImagePlan(Map.ofEntries(
 *                 Map.entry("name", "win_2022_test_20_10_gen2"),
 *                 Map.entry("product", "windows_2022_test"),
 *                 Map.entry("publisher", "testpublisher")
 *             ))
 *             .vmImagePublisher("testpublisher")
 *             .vmImageSku("win_2022_test_20_10_gen2")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:NodeType BE /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedClusters/{clusterName}/nodeTypes/{nodeTypeName}
 * ```
 */
public class NodeType internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabric.NodeType,
) : KotlinCustomResource(javaResource, NodeTypeMapper) {
    /**
     * Additional managed data disks.
     */
    public val additionalDataDisks: Output<List<VmssDataDiskResponse>>?
        get() = javaResource.additionalDataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vmssDataDiskResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The range of ports from which cluster assigned port to Service Fabric applications.
     */
    public val applicationPorts: Output<EndpointRangeDescriptionResponse>?
        get() = javaResource.applicationPorts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointRangeDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
     */
    public val capacities: Output<Map<String, String>>?
        get() = javaResource.capacities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
     */
    public val dataDiskLetter: Output<String>?
        get() = javaResource.dataDiskLetter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Disk size for the managed disk attached to the vms on the node type in GBs.
     */
    public val dataDiskSizeGB: Output<Int>?
        get() = javaResource.dataDiskSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed data disk type. Specifies the storage account type for the managed disk
     */
    public val dataDiskType: Output<String>?
        get() = javaResource.dataDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the network interface is accelerated networking-enabled.
     */
    public val enableAcceleratedNetworking: Output<Boolean>?
        get() = javaResource.enableAcceleratedNetworking().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable or disable the Host Encryption for the virtual machines on the node type. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this property is set to true for the resource.
     */
    public val enableEncryptionAtHost: Output<Boolean>?
        get() = javaResource.enableEncryptionAtHost().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether each node is allocated its own public IP address. This is only supported on secondary node types with custom Load Balancers.
     */
    public val enableNodePublicIP: Output<Boolean>?
        get() = javaResource.enableNodePublicIP().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the node type should be overprovisioned. It is only allowed for stateless node types.
     */
    public val enableOverProvisioning: Output<Boolean>?
        get() = javaResource.enableOverProvisioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The range of ephemeral ports that nodes in this node type should be configured with.
     */
    public val ephemeralPorts: Output<EndpointRangeDescriptionResponse>?
        get() = javaResource.ephemeralPorts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointRangeDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     */
    public val evictionPolicy: Output<String>?
        get() = javaResource.evictionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    public val frontendConfigurations: Output<List<FrontendConfigurationResponse>>?
        get() = javaResource.frontendConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        frontendConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Specifies the full host group resource Id. This property is used for deploying on azure dedicated hosts.
     */
    public val hostGroupId: Output<String>?
        get() = javaResource.hostGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the Service Fabric system services for the cluster will run on this node type. This setting cannot be changed once the node type is created.
     */
    public val isPrimary: Output<Boolean>
        get() = javaResource.isPrimary().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if there is capacity available and the VMs can be evicted at any time.
     */
    public val isSpotVM: Output<Boolean>?
        get() = javaResource.isSpotVM().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates if the node type can only host Stateless workloads.
     */
    public val isStateless: Output<Boolean>?
        get() = javaResource.isStateless().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if scale set associated with the node type can be composed of multiple placement groups.
     */
    public val multiplePlacementGroups: Output<Boolean>?
        get() = javaResource.multiplePlacementGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type must use custom load balancer.
     */
    public val natGatewayId: Output<String>?
        get() = javaResource.natGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    public val networkSecurityRules: Output<List<NetworkSecurityRuleResponse>>?
        get() = javaResource.networkSecurityRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        networkSecurityRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
     */
    public val placementProperties: Output<Map<String, String>>?
        get() = javaResource.placementProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The provisioning state of the node type resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies whether secure boot should be enabled on the nodeType. Can only be used with TrustedLaunch SecurityType
     */
    public val secureBootEnabled: Output<Boolean>?
        get() = javaResource.secureBootEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
     */
    public val securityType: Output<String>?
        get() = javaResource.securityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The node type sku.
     */
    public val sku: Output<NodeTypeSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nodeTypeSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Indicates the time duration after which the platform will not try to restore the VMSS SPOT instances specified as ISO 8601.
     */
    public val spotRestoreTimeout: Output<String>?
        get() = javaResource.spotRestoreTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the resource id of the subnet for the node type.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the use public load balancer. If not specified and the node type doesn't have its own frontend configuration, it will be attached to the default load balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a public load balancer to provide outbound connectivity.
     */
    public val useDefaultPublicLoadBalancer: Output<Boolean>?
        get() = javaResource.useDefaultPublicLoadBalancer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to support this feature.
     */
    public val useEphemeralOSDisk: Output<Boolean>?
        get() = javaResource.useEphemeralOSDisk().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to use the temporary disk for the service fabric data root, in which case no managed data disk will be attached and the temporary disk will be used. It is only allowed for stateless node types.
     */
    public val useTempDataDisk: Output<Boolean>?
        get() = javaResource.useTempDataDisk().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of extensions that should be installed onto the virtual machines.
     */
    public val vmExtensions: Output<List<VMSSExtensionResponse>>?
        get() = javaResource.vmExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> vMSSExtensionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
     */
    public val vmImageOffer: Output<String>?
        get() = javaResource.vmImageOffer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
     */
    public val vmImagePlan: Output<VmImagePlanResponse>?
        get() = javaResource.vmImagePlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vmImagePlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
     */
    public val vmImagePublisher: Output<String>?
        get() = javaResource.vmImagePublisher().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the resource id of the vm image. This parameter is used for custom vm image.
     */
    public val vmImageResourceId: Output<String>?
        get() = javaResource.vmImageResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
     */
    public val vmImageSku: Output<String>?
        get() = javaResource.vmImageSku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
     */
    public val vmImageVersion: Output<String>?
        get() = javaResource.vmImageVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of nodes in the node type. <br /><br />**Values:** <br />-1 - Use when auto scale rules are configured or sku.capacity is defined <br /> 0 - Not supported <br /> >0 - Use for manual scale.
     */
    public val vmInstanceCount: Output<Int>
        get() = javaResource.vmInstanceCount().applyValue({ args0 -> args0 })

    /**
     * Identities to assign to the virtual machine scale set under the node type.
     */
    public val vmManagedIdentity: Output<VmManagedIdentityResponse>?
        get() = javaResource.vmManagedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vmManagedIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The secrets to install in the virtual machines.
     */
    public val vmSecrets: Output<List<VaultSecretGroupResponse>>?
        get() = javaResource.vmSecrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> vaultSecretGroupResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
     */
    public val vmSetupActions: Output<List<String>>?
        get() = javaResource.vmSetupActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Indicates the resource id of the vm shared galleries image. This parameter is used for custom vm image.
     */
    public val vmSharedGalleryImageId: Output<String>?
        get() = javaResource.vmSharedGalleryImageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of virtual machines in the pool. All virtual machines in a pool are the same size. For example, Standard_D3.
     */
    public val vmSize: Output<String>?
        get() = javaResource.vmSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object NodeTypeMapper : ResourceMapper<NodeType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabric.NodeType::class == javaResource::class

    override fun map(javaResource: Resource): NodeType = NodeType(
        javaResource as
            com.pulumi.azurenative.servicefabric.NodeType,
    )
}

/**
 * @see [NodeType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NodeType].
 */
public suspend fun nodeType(name: String, block: suspend NodeTypeResourceBuilder.() -> Unit):
    NodeType {
    val builder = NodeTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NodeType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nodeType(name: String): NodeType {
    val builder = NodeTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
