@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The service load metric relative weight, compared to other metrics configured for this service, as a number.
 */
public enum class ServiceLoadMetricWeight(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight> {
    /**
     * Disables resource balancing for this metric. This value is zero.
     */
    Zero(com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight.Zero),

    /**
     * Specifies the metric weight of the service load as Low. The value is 1.
     */
    Low(com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight.Low),

    /**
     * Specifies the metric weight of the service load as Medium. The value is 2.
     */
    Medium(com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight.Medium),

    /**
     * Specifies the metric weight of the service load as High. The value is 3.
     */
    High(com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight.High),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ServiceLoadMetricWeight):
            ServiceLoadMetricWeight =
            ServiceLoadMetricWeight.values().first { it.javaValue == javaType }
    }
}
