@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ApplicationUserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The friendly name of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 */
public data class ApplicationUserAssignedIdentityArgs(
    public val name: Output<String>,
    public val principalId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ApplicationUserAssignedIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.ApplicationUserAssignedIdentityArgs =
        com.pulumi.azurenative.servicefabric.inputs.ApplicationUserAssignedIdentityArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .principalId(principalId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationUserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class ApplicationUserAssignedIdentityArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value The friendly name of user assigned identity.
     */
    @JvmName("pannkmkkqivtlthh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The principal id of user assigned identity.
     */
    @JvmName("msrrifbdqvhesvcj")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The friendly name of user assigned identity.
     */
    @JvmName("xkjulboxirhslmxy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The principal id of user assigned identity.
     */
    @JvmName("nqwbgkukggdnnuja")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): ApplicationUserAssignedIdentityArgs = ApplicationUserAssignedIdentityArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
    )
}
