@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.AverageServiceLoadScalingTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a scaling policy related to an average load of a metric/resource of a service.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'AverageServiceLoadTrigger'.
 * @property lowerLoadThreshold The lower limit of the load below which a scale in operation should be performed.
 * @property metricName The name of the metric for which usage should be tracked.
 * @property scaleInterval The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
 * @property upperLoadThreshold The upper limit of the load beyond which a scale out operation should be performed.
 * @property useOnlyPrimaryLoad Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
 */
public data class AverageServiceLoadScalingTriggerArgs(
    public val kind: Output<String>,
    public val lowerLoadThreshold: Output<Double>,
    public val metricName: Output<String>,
    public val scaleInterval: Output<String>,
    public val upperLoadThreshold: Output<Double>,
    public val useOnlyPrimaryLoad: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.AverageServiceLoadScalingTriggerArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.AverageServiceLoadScalingTriggerArgs =
        com.pulumi.azurenative.servicefabric.inputs.AverageServiceLoadScalingTriggerArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .lowerLoadThreshold(lowerLoadThreshold.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .scaleInterval(scaleInterval.applyValue({ args0 -> args0 }))
            .upperLoadThreshold(upperLoadThreshold.applyValue({ args0 -> args0 }))
            .useOnlyPrimaryLoad(useOnlyPrimaryLoad.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AverageServiceLoadScalingTriggerArgs].
 */
@PulumiTagMarker
public class AverageServiceLoadScalingTriggerArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var lowerLoadThreshold: Output<Double>? = null

    private var metricName: Output<String>? = null

    private var scaleInterval: Output<String>? = null

    private var upperLoadThreshold: Output<Double>? = null

    private var useOnlyPrimaryLoad: Output<Boolean>? = null

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'AverageServiceLoadTrigger'.
     */
    @JvmName("oskvhbovlhfjxjht")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The lower limit of the load below which a scale in operation should be performed.
     */
    @JvmName("ctgmyumlfuogqtdj")
    public suspend fun lowerLoadThreshold(`value`: Output<Double>) {
        this.lowerLoadThreshold = value
    }

    /**
     * @param value The name of the metric for which usage should be tracked.
     */
    @JvmName("pyywptdghqgskuaq")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("aqheimfllkaxhdxe")
    public suspend fun scaleInterval(`value`: Output<String>) {
        this.scaleInterval = value
    }

    /**
     * @param value The upper limit of the load beyond which a scale out operation should be performed.
     */
    @JvmName("bjvcewbnskkjenpx")
    public suspend fun upperLoadThreshold(`value`: Output<Double>) {
        this.upperLoadThreshold = value
    }

    /**
     * @param value Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
     */
    @JvmName("efunotsygjlvmysl")
    public suspend fun useOnlyPrimaryLoad(`value`: Output<Boolean>) {
        this.useOnlyPrimaryLoad = value
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'AverageServiceLoadTrigger'.
     */
    @JvmName("hhevjrimhkxrnmfe")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The lower limit of the load below which a scale in operation should be performed.
     */
    @JvmName("rqxtncdjxteeybwk")
    public suspend fun lowerLoadThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lowerLoadThreshold = mapped
    }

    /**
     * @param value The name of the metric for which usage should be tracked.
     */
    @JvmName("gosdbwrunfcsbkty")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
     */
    @JvmName("ervcnmecvfhaihep")
    public suspend fun scaleInterval(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleInterval = mapped
    }

    /**
     * @param value The upper limit of the load beyond which a scale out operation should be performed.
     */
    @JvmName("ubfukxdasvhiidgv")
    public suspend fun upperLoadThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upperLoadThreshold = mapped
    }

    /**
     * @param value Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
     */
    @JvmName("ihfnkumdjlbthelv")
    public suspend fun useOnlyPrimaryLoad(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useOnlyPrimaryLoad = mapped
    }

    internal fun build(): AverageServiceLoadScalingTriggerArgs = AverageServiceLoadScalingTriggerArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        lowerLoadThreshold = lowerLoadThreshold ?: throw PulumiNullFieldException("lowerLoadThreshold"),
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        scaleInterval = scaleInterval ?: throw PulumiNullFieldException("scaleInterval"),
        upperLoadThreshold = upperLoadThreshold ?: throw PulumiNullFieldException("upperLoadThreshold"),
        useOnlyPrimaryLoad = useOnlyPrimaryLoad ?: throw PulumiNullFieldException("useOnlyPrimaryLoad"),
    )
}
