@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypeVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationTypeName The name of the application type name resource.
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 * @property version The application type version.
 */
public data class GetManagedClusterApplicationTypeVersionPlainArgs(
    public val applicationTypeName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
    public val version: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypeVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypeVersionPlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypeVersionPlainArgs.builder()
            .applicationTypeName(applicationTypeName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedClusterApplicationTypeVersionPlainArgs].
 */
@PulumiTagMarker
public class GetManagedClusterApplicationTypeVersionPlainArgsBuilder internal constructor() {
    private var applicationTypeName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("ictfbybngvcmlcwv")
    public suspend fun applicationTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationTypeName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("abqqbddnwjwxedee")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gfrcofjpuoewtmef")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The application type version.
     */
    @JvmName("qhhyhhyenvskgwln")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetManagedClusterApplicationTypeVersionPlainArgs =
        GetManagedClusterApplicationTypeVersionPlainArgs(
            applicationTypeName = applicationTypeName ?: throw PulumiNullFieldException("applicationTypeName"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            version = version ?: throw PulumiNullFieldException("version"),
        )
}
