@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.NetworkSecurityRuleArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.Access
import com.pulumi.azurenative.servicefabric.kotlin.enums.Direction
import com.pulumi.azurenative.servicefabric.kotlin.enums.NsgProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a network security rule.
 * @property access The network traffic is allowed or denied.
 * @property description Network security rule description.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationPortRange he destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction Network security rule direction.
 * @property name Network security rule name.
 * @property priority The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 */
public data class NetworkSecurityRuleArgs(
    public val access: Output<Either<String, Access>>,
    public val description: Output<String>? = null,
    public val destinationAddressPrefix: Output<String>? = null,
    public val destinationAddressPrefixes: Output<List<String>>? = null,
    public val destinationPortRange: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val direction: Output<Either<String, Direction>>,
    public val name: Output<String>,
    public val priority: Output<Int>,
    public val protocol: Output<Either<String, NsgProtocol>>,
    public val sourceAddressPrefix: Output<String>? = null,
    public val sourceAddressPrefixes: Output<List<String>>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.NetworkSecurityRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.NetworkSecurityRuleArgs =
        com.pulumi.azurenative.servicefabric.inputs.NetworkSecurityRuleArgs.builder()
            .access(
                access.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefix(destinationAddressPrefix?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefixes(
                destinationAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceAddressPrefix(sourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefixes(sourceAddressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkSecurityRuleArgs].
 */
@PulumiTagMarker
public class NetworkSecurityRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, Access>>? = null

    private var description: Output<String>? = null

    private var destinationAddressPrefix: Output<String>? = null

    private var destinationAddressPrefixes: Output<List<String>>? = null

    private var destinationPortRange: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var direction: Output<Either<String, Direction>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<Either<String, NsgProtocol>>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourceAddressPrefixes: Output<List<String>>? = null

    private var sourcePortRange: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("noorsmlxmkxyepbq")
    public suspend fun access(`value`: Output<Either<String, Access>>) {
        this.access = value
    }

    /**
     * @param value Network security rule description.
     */
    @JvmName("jlhcvuafjwaaxwjl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("mtaybqgegtxjtoew")
    public suspend fun destinationAddressPrefix(`value`: Output<String>) {
        this.destinationAddressPrefix = value
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("xibdvtrunyktfbel")
    public suspend fun destinationAddressPrefixes(`value`: Output<List<String>>) {
        this.destinationAddressPrefixes = value
    }

    @JvmName("bqgjrwnbudylnbmw")
    public suspend fun destinationAddressPrefixes(vararg values: Output<String>) {
        this.destinationAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("nyveflchophwmquc")
    public suspend fun destinationAddressPrefixes(values: List<Output<String>>) {
        this.destinationAddressPrefixes = Output.all(values)
    }

    /**
     * @param value he destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("xghhivgdynmaycix")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("stlfhdbfbjwjbjhn")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("batwcofuxqurmxsf")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("birtwndmktlookkm")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value Network security rule direction.
     */
    @JvmName("neykbqypjvvxtqkq")
    public suspend fun direction(`value`: Output<Either<String, Direction>>) {
        this.direction = value
    }

    /**
     * @param value Network security rule name.
     */
    @JvmName("optmjeuyomcheckq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("gkmwgobmxnuxiemu")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("ryuexhuekpjvebxc")
    public suspend fun protocol(`value`: Output<Either<String, NsgProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("ccwfxvaxsvrxuvft")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("jrigavslgwhalakk")
    public suspend fun sourceAddressPrefixes(`value`: Output<List<String>>) {
        this.sourceAddressPrefixes = value
    }

    @JvmName("ormeiqeegheyasxi")
    public suspend fun sourceAddressPrefixes(vararg values: Output<String>) {
        this.sourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("vthjnvrudauakovw")
    public suspend fun sourceAddressPrefixes(values: List<Output<String>>) {
        this.sourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("jxbaalmxtmnucdag")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("urrvpbawhcbnefst")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("excpyleugstglafs")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("nkcygrnqcmxijovg")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("rceuqyjxueumkbkw")
    public suspend fun access(`value`: Either<String, Access>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("bfitfqnyhheuxhof")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("ekuykkxwnyxwyvxh")
    public fun access(`value`: Access) {
        val toBeMapped = Either.ofRight<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Network security rule description.
     */
    @JvmName("ukrtwiyqkajuwsby")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("tbaakewjkmtvkcnp")
    public suspend fun destinationAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefix = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("oaubqybstkohkjem")
    public suspend fun destinationAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("duvkewxhfjxclyff")
    public suspend fun destinationAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param value he destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("vbeqmqysqjqlatfy")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("qlflakrrghgnfbnb")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("edcohlevamqprboy")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value Network security rule direction.
     */
    @JvmName("xdhhcjtnrnoypeqp")
    public suspend fun direction(`value`: Either<String, Direction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Network security rule direction.
     */
    @JvmName("hqkujxwbqxjbovfx")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Network security rule direction.
     */
    @JvmName("twytdtxlitjocgur")
    public fun direction(`value`: Direction) {
        val toBeMapped = Either.ofRight<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Network security rule name.
     */
    @JvmName("wobxlbuegiwfkwkt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("frnnyptixqsbsjtt")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("srvnwwxmfsjwbbls")
    public suspend fun protocol(`value`: Either<String, NsgProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("gavpwnsdjjbkicar")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NsgProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("dcdkteekvechwrtc")
    public fun protocol(`value`: NsgProtocol) {
        val toBeMapped = Either.ofRight<String, NsgProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("kjaqjicqhguiajit")
    public suspend fun sourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("vxhbkxopkktuvwnh")
    public suspend fun sourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("rakeakxnhptysigl")
    public suspend fun sourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("murojhagnbffnwgm")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("jaeoeunknlrwepwd")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("yijybplmwhgsxffv")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    internal fun build(): NetworkSecurityRuleArgs = NetworkSecurityRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        description = description,
        destinationAddressPrefix = destinationAddressPrefix,
        destinationAddressPrefixes = destinationAddressPrefixes,
        destinationPortRange = destinationPortRange,
        destinationPortRanges = destinationPortRanges,
        direction = direction ?: throw PulumiNullFieldException("direction"),
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        sourceAddressPrefix = sourceAddressPrefix,
        sourceAddressPrefixes = sourceAddressPrefixes,
        sourcePortRange = sourcePortRange,
        sourcePortRanges = sourcePortRanges,
    )
}
