@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.FailureAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The policy used for monitoring the application upgrade
 * @property failureAction The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
 * @property healthCheckRetryTimeout The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property healthCheckStableDuration The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property healthCheckWaitDuration The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property upgradeDomainTimeout The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property upgradeTimeout The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 */
public data class RollingUpgradeMonitoringPolicyArgs(
    public val failureAction: Output<Either<String, FailureAction>>,
    public val healthCheckRetryTimeout: Output<String>,
    public val healthCheckStableDuration: Output<String>,
    public val healthCheckWaitDuration: Output<String>,
    public val upgradeDomainTimeout: Output<String>,
    public val upgradeTimeout: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs.builder()
            .failureAction(
                failureAction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .healthCheckRetryTimeout(healthCheckRetryTimeout.applyValue({ args0 -> args0 }))
            .healthCheckStableDuration(healthCheckStableDuration.applyValue({ args0 -> args0 }))
            .healthCheckWaitDuration(healthCheckWaitDuration.applyValue({ args0 -> args0 }))
            .upgradeDomainTimeout(upgradeDomainTimeout.applyValue({ args0 -> args0 }))
            .upgradeTimeout(upgradeTimeout.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RollingUpgradeMonitoringPolicyArgs].
 */
@PulumiTagMarker
public class RollingUpgradeMonitoringPolicyArgsBuilder internal constructor() {
    private var failureAction: Output<Either<String, FailureAction>>? = null

    private var healthCheckRetryTimeout: Output<String>? = null

    private var healthCheckStableDuration: Output<String>? = null

    private var healthCheckWaitDuration: Output<String>? = null

    private var upgradeDomainTimeout: Output<String>? = null

    private var upgradeTimeout: Output<String>? = null

    /**
     * @param value The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
     */
    @JvmName("awbevrgwdfcaybvf")
    public suspend fun failureAction(`value`: Output<Either<String, FailureAction>>) {
        this.failureAction = value
    }

    /**
     * @param value The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("olhexqonlbwcujqi")
    public suspend fun healthCheckRetryTimeout(`value`: Output<String>) {
        this.healthCheckRetryTimeout = value
    }

    /**
     * @param value The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("ivbgsunuhdffdwwb")
    public suspend fun healthCheckStableDuration(`value`: Output<String>) {
        this.healthCheckStableDuration = value
    }

    /**
     * @param value The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("eeialxcnqvohvyuo")
    public suspend fun healthCheckWaitDuration(`value`: Output<String>) {
        this.healthCheckWaitDuration = value
    }

    /**
     * @param value The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("meahvvjcybdilcam")
    public suspend fun upgradeDomainTimeout(`value`: Output<String>) {
        this.upgradeDomainTimeout = value
    }

    /**
     * @param value The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("qccnclevrukckjnh")
    public suspend fun upgradeTimeout(`value`: Output<String>) {
        this.upgradeTimeout = value
    }

    /**
     * @param value The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
     */
    @JvmName("jlxfcynntdesotcb")
    public suspend fun failureAction(`value`: Either<String, FailureAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureAction = mapped
    }

    /**
     * @param value The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
     */
    @JvmName("fuplhebynejryrep")
    public fun failureAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FailureAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureAction = mapped
    }

    /**
     * @param value The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
     */
    @JvmName("suwcycqsufkrwuwj")
    public fun failureAction(`value`: FailureAction) {
        val toBeMapped = Either.ofRight<String, FailureAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureAction = mapped
    }

    /**
     * @param value The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("knpuhncqggigjrwq")
    public suspend fun healthCheckRetryTimeout(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckRetryTimeout = mapped
    }

    /**
     * @param value The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("ttcuaekdekljeycw")
    public suspend fun healthCheckStableDuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckStableDuration = mapped
    }

    /**
     * @param value The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("otmqjpdtynvtsinm")
    public suspend fun healthCheckWaitDuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckWaitDuration = mapped
    }

    /**
     * @param value The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("gwvshawiehoriedf")
    public suspend fun upgradeDomainTimeout(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeDomainTimeout = mapped
    }

    /**
     * @param value The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
     */
    @JvmName("mdaioymbggwhxnec")
    public suspend fun upgradeTimeout(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeTimeout = mapped
    }

    internal fun build(): RollingUpgradeMonitoringPolicyArgs = RollingUpgradeMonitoringPolicyArgs(
        failureAction = failureAction ?: throw PulumiNullFieldException("failureAction"),
        healthCheckRetryTimeout = healthCheckRetryTimeout ?: throw
            PulumiNullFieldException("healthCheckRetryTimeout"),
        healthCheckStableDuration = healthCheckStableDuration ?: throw
            PulumiNullFieldException("healthCheckStableDuration"),
        healthCheckWaitDuration = healthCheckWaitDuration ?: throw
            PulumiNullFieldException("healthCheckWaitDuration"),
        upgradeDomainTimeout = upgradeDomainTimeout ?: throw
            PulumiNullFieldException("upgradeDomainTimeout"),
        upgradeTimeout = upgradeTimeout ?: throw PulumiNullFieldException("upgradeTimeout"),
    )
}
