@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The name of the domain that should used for placement as per this policy.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'NonPartiallyPlaceService'.
 */
public data class ServicePlacementNonPartiallyPlaceServicePolicyArgs(
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementNonPartiallyPlaceServicePolicyArgs].
 */
@PulumiTagMarker
public class ServicePlacementNonPartiallyPlaceServicePolicyArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'NonPartiallyPlaceService'.
     */
    @JvmName("itonqcilcdlydfvg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'NonPartiallyPlaceService'.
     */
    @JvmName("wfgrxmnuyygblptt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementNonPartiallyPlaceServicePolicyArgs =
        ServicePlacementNonPartiallyPlaceServicePolicyArgs(
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
