@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.SubnetArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.PrivateEndpointNetworkPolicies
import com.pulumi.azurenative.servicefabric.kotlin.enums.PrivateLinkServiceNetworkPolicies
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a Subnet.
 * @property enableIpv6 Indicates wether to enable Ipv6 or not. If not provided, it will take the same configuration as the cluster.
 * @property name Subnet name.
 * @property networkSecurityGroupId Full resource id for the network security group.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 */
public data class SubnetArgs(
    public val enableIpv6: Output<Boolean>? = null,
    public val name: Output<String>,
    public val networkSecurityGroupId: Output<String>? = null,
    public val privateEndpointNetworkPolicies: Output<Either<String, PrivateEndpointNetworkPolicies>>? =
        null,
    public val privateLinkServiceNetworkPolicies:
    Output<Either<String, PrivateLinkServiceNetworkPolicies>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.SubnetArgs =
        com.pulumi.azurenative.servicefabric.inputs.SubnetArgs.builder()
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .networkSecurityGroupId(networkSecurityGroupId?.applyValue({ args0 -> args0 }))
            .privateEndpointNetworkPolicies(
                privateEndpointNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceNetworkPolicies(
                privateLinkServiceNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var enableIpv6: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var networkSecurityGroupId: Output<String>? = null

    private var privateEndpointNetworkPolicies:
        Output<Either<String, PrivateEndpointNetworkPolicies>>? = null

    private var privateLinkServiceNetworkPolicies:
        Output<Either<String, PrivateLinkServiceNetworkPolicies>>? = null

    /**
     * @param value Indicates wether to enable Ipv6 or not. If not provided, it will take the same configuration as the cluster.
     */
    @JvmName("yxjflctgrfarrxwl")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value Subnet name.
     */
    @JvmName("ugyptogcuqtxyfmh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Full resource id for the network security group.
     */
    @JvmName("bvqtrlrfulpfxkwx")
    public suspend fun networkSecurityGroupId(`value`: Output<String>) {
        this.networkSecurityGroupId = value
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("yytnqrsdpbxemdsa")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Output<Either<String, PrivateEndpointNetworkPolicies>>) {
        this.privateEndpointNetworkPolicies = value
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("qaefgmegwcijxpbr")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Output<Either<String, PrivateLinkServiceNetworkPolicies>>) {
        this.privateLinkServiceNetworkPolicies = value
    }

    /**
     * @param value Indicates wether to enable Ipv6 or not. If not provided, it will take the same configuration as the cluster.
     */
    @JvmName("kfabnyxacbgkough")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value Subnet name.
     */
    @JvmName("eohijbrfymgcetwx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Full resource id for the network security group.
     */
    @JvmName("qvcwsjodaoeopdor")
    public suspend fun networkSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroupId = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("yamfdnqhhuolfjcs")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Either<String, PrivateEndpointNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("mkuddisfvtutpjpx")
    public fun privateEndpointNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("lnsaltfhrgmrieve")
    public fun privateEndpointNetworkPolicies(`value`: PrivateEndpointNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("dfpilrduysnfulpe")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Either<String, PrivateLinkServiceNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("tpewxnrfsuwknwso")
    public fun privateLinkServiceNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("ubqglsksbmuqvwho")
    public fun privateLinkServiceNetworkPolicies(`value`: PrivateLinkServiceNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        enableIpv6 = enableIpv6,
        name = name ?: throw PulumiNullFieldException("name"),
        networkSecurityGroupId = networkSecurityGroupId,
        privateEndpointNetworkPolicies = privateEndpointNetworkPolicies,
        privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies,
    )
}
